/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.probe;

import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;

public interface QuotaProbe {
    public QuotaRoot getQuotaRoot(MailboxPath var1) throws MailboxException;

    public Quota<QuotaCountLimit, QuotaCountUsage> getMessageCountQuota(QuotaRoot var1) throws MailboxException;

    public Quota<QuotaSizeLimit, QuotaSizeUsage> getStorageQuota(QuotaRoot var1) throws MailboxException;

    public Optional<QuotaCountLimit> getMaxMessageCount(QuotaRoot var1) throws MailboxException;

    public Optional<QuotaSizeLimit> getMaxStorage(QuotaRoot var1) throws MailboxException;

    public Optional<QuotaCountLimit> getGlobalMaxMessageCount() throws MailboxException;

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() throws MailboxException;

    public void setMaxMessageCount(QuotaRoot var1, QuotaCountLimit var2) throws MailboxException;

    public void setMaxStorage(QuotaRoot var1, QuotaSizeLimit var2) throws MailboxException;

    public void setGlobalMaxMessageCount(QuotaCountLimit var1) throws MailboxException;

    public void setGlobalMaxStorage(QuotaSizeLimit var1) throws MailboxException;

    public void setDomainMaxMessage(Domain var1, QuotaCountLimit var2) throws MailboxException;

    public void setDomainMaxStorage(Domain var1, QuotaSizeLimit var2) throws MailboxException;
}

