/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.indices.PutAliasResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class PutAliasRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Query filter;
    private final List<String> index;
    @Nullable
    private final String indexRouting;
    @Nullable
    private final Boolean isWriteIndex;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time clusterManagerTimeout;
    private final String name;
    @Nullable
    private final String routing;
    @Nullable
    private final String searchRouting;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutAliasRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAliasRequest::setupPutAliasRequestDeserializer);
    public static final Endpoint<PutAliasRequest, PutAliasResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAliasRequest, PutAliasResponse>(request -> "PUT", request -> {
        boolean _name = true;
        int _index = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_alias");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_aliases");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", request.clusterManagerTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAliasResponse._DESERIALIZER);

    private PutAliasRequest(Builder builder) {
        this.filter = builder.filter;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.indexRouting = builder.indexRouting;
        this.isWriteIndex = builder.isWriteIndex;
        this.masterTimeout = builder.masterTimeout;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.routing = builder.routing;
        this.searchRouting = builder.searchRouting;
        this.timeout = builder.timeout;
    }

    public static PutAliasRequest of(Function<Builder, ObjectBuilder<PutAliasRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final String indexRouting() {
        return this.indexRouting;
    }

    @Nullable
    public final Boolean isWriteIndex() {
        return this.isWriteIndex;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final String searchRouting() {
        return this.searchRouting;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.indexRouting != null) {
            generator.writeKey("index_routing");
            generator.write(this.indexRouting);
        }
        if (this.isWriteIndex != null) {
            generator.writeKey("is_write_index");
            generator.write(this.isWriteIndex.booleanValue());
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.searchRouting != null) {
            generator.writeKey("search_routing");
            generator.write(this.searchRouting);
        }
    }

    protected static void setupPutAliasRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::indexRouting, JsonpDeserializer.stringDeserializer(), "index_routing");
        op.add(Builder::isWriteIndex, JsonpDeserializer.booleanDeserializer(), "is_write_index");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::searchRouting, JsonpDeserializer.stringDeserializer(), "search_routing");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PutAliasRequest> {
        @Nullable
        private Query filter;
        private List<String> index;
        @Nullable
        private String indexRouting;
        @Nullable
        private Boolean isWriteIndex;
        @Deprecated
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time clusterManagerTimeout;
        private String name;
        @Nullable
        private String routing;
        @Nullable
        private String searchRouting;
        @Nullable
        private Time timeout;

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder indexRouting(@Nullable String value) {
            this.indexRouting = value;
            return this;
        }

        public final Builder isWriteIndex(@Nullable Boolean value) {
            this.isWriteIndex = value;
            return this;
        }

        @Deprecated
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder searchRouting(@Nullable String value) {
            this.searchRouting = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public PutAliasRequest build() {
            this._checkSingleUse();
            return new PutAliasRequest(this);
        }
    }
}

