/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.github.fge.lambdas.Throwing;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.SearchConfiguration;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.jmap.draft.JMAPModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.queue.rabbitmq.MailQueueViewChoice;
import org.apache.james.server.core.JamesServerResourceLoader;
import org.apache.james.server.core.MissingArgumentException;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.utils.PropertiesProvider;
import org.apache.james.vault.VaultConfiguration;

public class CassandraRabbitMQJamesConfiguration
implements Configuration {
    private final Configuration.ConfigurationPath configurationPath;
    private final JamesDirectoriesProvider directories;
    private final BlobStoreConfiguration blobStoreConfiguration;
    private final SearchConfiguration searchConfiguration;
    private final UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation;
    private final MailQueueViewChoice mailQueueViewChoice;
    private final VaultConfiguration vaultConfiguration;
    private final boolean jmapEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public CassandraRabbitMQJamesConfiguration(Configuration.ConfigurationPath configurationPath, JamesDirectoriesProvider directories, BlobStoreConfiguration blobStoreConfiguration, SearchConfiguration searchConfiguration, UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation, MailQueueViewChoice mailQueueViewChoice, VaultConfiguration vaultConfiguration, boolean jmapEnabled) {
        this.configurationPath = configurationPath;
        this.directories = directories;
        this.blobStoreConfiguration = blobStoreConfiguration;
        this.searchConfiguration = searchConfiguration;
        this.usersRepositoryImplementation = usersRepositoryImplementation;
        this.mailQueueViewChoice = mailQueueViewChoice;
        this.vaultConfiguration = vaultConfiguration;
        this.jmapEnabled = jmapEnabled;
    }

    public MailQueueViewChoice getMailQueueViewChoice() {
        return this.mailQueueViewChoice;
    }

    public Configuration.ConfigurationPath configurationPath() {
        return this.configurationPath;
    }

    public JamesDirectoriesProvider directories() {
        return this.directories;
    }

    public BlobStoreConfiguration blobStoreConfiguration() {
        return this.blobStoreConfiguration;
    }

    public SearchConfiguration searchConfiguration() {
        return this.searchConfiguration;
    }

    public UsersRepositoryModuleChooser.Implementation getUsersRepositoryImplementation() {
        return this.usersRepositoryImplementation;
    }

    public VaultConfiguration getVaultConfiguration() {
        return this.vaultConfiguration;
    }

    public boolean isJmapEnabled() {
        return this.jmapEnabled;
    }

    public static class Builder {
        private Optional<SearchConfiguration> searchConfiguration = Optional.empty();
        private Optional<BlobStoreConfiguration> blobStoreConfiguration;
        private Optional<String> rootDirectory = Optional.empty();
        private Optional<Configuration.ConfigurationPath> configurationPath = Optional.empty();
        private Optional<MailQueueViewChoice> mailQueueViewChoice;
        private Optional<UsersRepositoryModuleChooser.Implementation> usersRepositoryImplementation;
        private Optional<VaultConfiguration> vaultConfiguration;
        private Optional<Boolean> jmapEnabled;

        private Builder() {
            this.blobStoreConfiguration = Optional.empty();
            this.usersRepositoryImplementation = Optional.empty();
            this.mailQueueViewChoice = Optional.empty();
            this.vaultConfiguration = Optional.empty();
            this.jmapEnabled = Optional.empty();
        }

        public Builder workingDirectory(String path) {
            this.rootDirectory = Optional.of(path);
            return this;
        }

        public Builder workingDirectory(File file) {
            this.rootDirectory = Optional.of(file.getAbsolutePath());
            return this;
        }

        public Builder useWorkingDirectoryEnvProperty() {
            this.rootDirectory = Optional.ofNullable(System.getProperty("working.directory"));
            if (!this.rootDirectory.isPresent()) {
                throw new MissingArgumentException("Server needs a working.directory env entry");
            }
            return this;
        }

        public Builder configurationPath(Configuration.ConfigurationPath path) {
            this.configurationPath = Optional.of(path);
            return this;
        }

        public Builder configurationFromClasspath() {
            this.configurationPath = Optional.of(new Configuration.ConfigurationPath("classpath:"));
            return this;
        }

        public Builder blobStore(BlobStoreConfiguration blobStoreConfiguration) {
            this.blobStoreConfiguration = Optional.of(blobStoreConfiguration);
            return this;
        }

        public Builder searchConfiguration(SearchConfiguration searchConfiguration) {
            this.searchConfiguration = Optional.of(searchConfiguration);
            return this;
        }

        public Builder usersRepository(UsersRepositoryModuleChooser.Implementation implementation) {
            this.usersRepositoryImplementation = Optional.of(implementation);
            return this;
        }

        public Builder mailQueueViewChoice(MailQueueViewChoice mailQueueViewChoice) {
            this.mailQueueViewChoice = Optional.of(mailQueueViewChoice);
            return this;
        }

        public Builder vaultConfiguration(VaultConfiguration vaultConfiguration) {
            this.vaultConfiguration = Optional.of(vaultConfiguration);
            return this;
        }

        public Builder enableJMAP() {
            this.jmapEnabled = Optional.of(true);
            return this;
        }

        public CassandraRabbitMQJamesConfiguration build() {
            Configuration.ConfigurationPath configurationPath = this.configurationPath.orElse(new Configuration.ConfigurationPath("file://conf/"));
            JamesServerResourceLoader directories = new JamesServerResourceLoader(this.rootDirectory.orElseThrow(() -> new MissingArgumentException("Server needs a working.directory env entry")));
            FileSystemImpl fileSystem = new FileSystemImpl((JamesDirectoriesProvider)directories);
            PropertiesProvider propertiesProvider = new PropertiesProvider((FileSystem)fileSystem, configurationPath);
            BlobStoreConfiguration blobStoreConfiguration = this.blobStoreConfiguration.orElseGet((Supplier<BlobStoreConfiguration>)Throwing.supplier(() -> BlobStoreConfiguration.parse((PropertiesProvider)propertiesProvider)));
            SearchConfiguration searchConfiguration = this.searchConfiguration.orElseGet((Supplier<SearchConfiguration>)Throwing.supplier(() -> SearchConfiguration.parse((PropertiesProvider)propertiesProvider)));
            FileConfigurationProvider configurationProvider = new FileConfigurationProvider((FileSystem)fileSystem, (Configuration)Configuration.Basic.builder().configurationPath(configurationPath).workingDirectory(directories.getRootDirectory()).build());
            UsersRepositoryModuleChooser.Implementation usersRepositoryChoice = this.usersRepositoryImplementation.orElseGet(() -> UsersRepositoryModuleChooser.Implementation.parse((FileConfigurationProvider)configurationProvider));
            MailQueueViewChoice mailQueueViewChoice = this.mailQueueViewChoice.orElseGet((Supplier<MailQueueViewChoice>)Throwing.supplier(() -> MailQueueViewChoice.parse((PropertiesProvider)propertiesProvider)));
            VaultConfiguration vaultConfiguration = this.vaultConfiguration.orElseGet(() -> {
                try {
                    return VaultConfiguration.from((org.apache.commons.configuration2.Configuration)configurationProvider.getConfiguration("deletedMessageVault"));
                }
                catch (ConfigurationException e) {
                    return VaultConfiguration.DEFAULT;
                }
            });
            boolean jmapEnabled = this.jmapEnabled.orElseGet(() -> {
                try {
                    return JMAPModule.parseConfiguration((PropertiesProvider)propertiesProvider).isEnabled();
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            });
            return new CassandraRabbitMQJamesConfiguration(configurationPath, (JamesDirectoriesProvider)directories, blobStoreConfiguration, searchConfiguration, usersRepositoryChoice, mailQueueViewChoice, vaultConfiguration, jmapEnabled);
        }
    }
}

