/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.validation;

import java.util.Optional;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.webadmin.utils.ErrorResponder;

public abstract class Quotas {
    public static QuotaCountLimit quotaCount(String serialized) {
        return Quotas.minusOneToEmpty(Quotas.parseToLong(serialized)).map(QuotaCountLimit::count).orElse(QuotaCountLimit.unlimited());
    }

    public static QuotaSizeLimit quotaSize(String serialized) {
        return Quotas.minusOneToEmpty(Quotas.parseToLong(serialized)).map(QuotaSizeLimit::size).orElse(QuotaSizeLimit.unlimited());
    }

    private static Optional<Long> minusOneToEmpty(long value) {
        if (value < -1L) {
            throw Quotas.generateInvalidInputError().haltError();
        }
        if (value == -1L) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    private static long parseToLong(String serialized) {
        try {
            return Long.parseLong(serialized);
        }
        catch (IllegalArgumentException e) {
            throw Quotas.generateInvalidInputError().cause((Exception)e).haltError();
        }
    }

    private static ErrorResponder generateInvalidInputError() {
        return ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid quota. Need to be an integer value greater or equal to -1");
    }
}

