/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.FunctionChainer;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.exceptions.MailboxNotOwnedException;
import org.apache.james.jmap.draft.exceptions.MailboxParentNotFoundException;
import org.apache.james.jmap.draft.methods.SetMailboxesProcessor;
import org.apache.james.jmap.draft.model.MailboxCreationId;
import org.apache.james.jmap.draft.model.MailboxFactory;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetMailboxesRequest;
import org.apache.james.jmap.draft.model.SetMailboxesResponse;
import org.apache.james.jmap.draft.model.mailbox.Mailbox;
import org.apache.james.jmap.draft.model.mailbox.MailboxCreateRequest;
import org.apache.james.jmap.draft.utils.DependencyGraph;
import org.apache.james.jmap.draft.utils.SortingHierarchicalCollections;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.InboxAlreadyCreated;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMailboxesCreationProcessor
implements SetMailboxesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetMailboxesCreationProcessor.class);
    private final MailboxManager mailboxManager;
    private final SortingHierarchicalCollections<Map.Entry<MailboxCreationId, MailboxCreateRequest>, MailboxCreationId> sortingHierarchicalCollections;
    private final MailboxFactory mailboxFactory;
    private final MailboxId.Factory mailboxIdFactory;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    SetMailboxesCreationProcessor(MailboxManager mailboxManager, MailboxFactory mailboxFactory, MailboxId.Factory mailboxIdFactory, MetricFactory metricFactory) {
        this.mailboxManager = mailboxManager;
        this.metricFactory = metricFactory;
        this.sortingHierarchicalCollections = new SortingHierarchicalCollections<Map.Entry, MailboxCreationId>(Map.Entry::getKey, x -> ((MailboxCreateRequest)x.getValue()).getParentId());
        this.mailboxFactory = mailboxFactory;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    @Override
    public SetMailboxesResponse process(SetMailboxesRequest request, MailboxSession mailboxSession) {
        TimeMetric timeMetric = this.metricFactory.timer("JMAP-SetMailboxesCreationProcessor");
        SetMailboxesResponse.Builder builder = SetMailboxesResponse.builder();
        try {
            HashMap creationIdsToCreatedMailboxId = new HashMap();
            this.sortingHierarchicalCollections.sortFromRootToLeaf((Collection<Map.Entry<MailboxCreationId, MailboxCreateRequest>>)request.getCreate().entrySet()).forEach(entry -> this.createMailbox((MailboxCreationId)entry.getKey(), (MailboxCreateRequest)entry.getValue(), mailboxSession, creationIdsToCreatedMailboxId, builder));
        }
        catch (DependencyGraph.CycleDetectedException e) {
            this.markRequestsAsNotCreatedDueToCycle(request, builder);
        }
        timeMetric.stopAndPublish();
        return builder.build();
    }

    private void markRequestsAsNotCreatedDueToCycle(SetMailboxesRequest request, SetMailboxesResponse.Builder builder) {
        request.getCreate().forEach((key, value) -> builder.notCreated((MailboxCreationId)key, SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description("The created mailboxes introduce a cycle.").build()));
    }

    private void createMailbox(MailboxCreationId mailboxCreationId, MailboxCreateRequest mailboxRequest, MailboxSession mailboxSession, Map<MailboxCreationId, MailboxId> creationIdsToCreatedMailboxId, SetMailboxesResponse.Builder builder) {
        try {
            this.ensureValidMailboxName(mailboxRequest, mailboxSession);
            MailboxPath mailboxPath = this.computeMailboxPath(mailboxRequest, creationIdsToCreatedMailboxId, mailboxSession);
            Optional mailboxId = this.mailboxManager.createMailbox(mailboxPath, MailboxManager.CreateOption.CREATE_SUBSCRIPTION, mailboxSession);
            Optional mailbox = mailboxId.flatMap(id -> this.mailboxFactory.builder().id((MailboxId)id).session(mailboxSession).build().blockOptional());
            if (mailbox.isPresent()) {
                builder.created(mailboxCreationId, (Mailbox)mailbox.get());
                creationIdsToCreatedMailboxId.put(mailboxCreationId, ((Mailbox)mailbox.get()).getId());
            } else {
                builder.notCreated(mailboxCreationId, SetError.builder().type(SetError.Type.ERROR).description("An error occurred when creating the mailbox").build());
            }
        }
        catch (TooLongMailboxNameException e) {
            builder.notCreated(mailboxCreationId, SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description("The mailbox name length is too long").build());
        }
        catch (MailboxNotOwnedException e) {
            builder.notCreated(mailboxCreationId, SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description("The mailbox can not be created with a parent mailbox belonging to another user").build());
        }
        catch (MailboxParentNotFoundException | MailboxNameException e) {
            builder.notCreated(mailboxCreationId, SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description(e.getMessage()).build());
        }
        catch (InboxAlreadyCreated e) {
            String message = String.format("The mailbox '%s' already exists as 'INBOX'", e.getMailboxName());
            LOGGER.error(message, (Throwable)e);
            builder.notCreated(mailboxCreationId, SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description(message).build());
        }
        catch (MailboxExistsException e) {
            String message = String.format("The mailbox '%s' already exists.", mailboxCreationId.getCreationId());
            builder.notCreated(mailboxCreationId, SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description(message).build());
        }
        catch (MailboxException e) {
            String message = String.format("An error occurred when creating the mailbox '%s'", mailboxCreationId.getCreationId());
            LOGGER.error(message, (Throwable)e);
            builder.notCreated(mailboxCreationId, SetError.builder().type(SetError.Type.ERROR).description(message).build());
        }
    }

    private void ensureValidMailboxName(MailboxCreateRequest mailboxRequest, MailboxSession mailboxSession) throws MailboxNameException {
        char pathDelimiter;
        String name = mailboxRequest.getName();
        if (name.contains(String.valueOf(pathDelimiter = mailboxSession.getPathDelimiter()))) {
            throw new MailboxNameException(String.format("The mailbox '%s' contains an illegal character: '%c'", name, Character.valueOf(pathDelimiter)));
        }
    }

    private MailboxPath computeMailboxPath(MailboxCreateRequest mailboxRequest, Map<MailboxCreationId, MailboxId> creationIdsToCreatedMailboxId, MailboxSession mailboxSession) throws MailboxException {
        if (mailboxRequest.getParentId().isPresent()) {
            MailboxCreationId parentId = mailboxRequest.getParentId().get();
            MailboxPath parentPath = this.getMailboxPath(creationIdsToCreatedMailboxId, mailboxSession, parentId);
            this.assertBelongsToUser(parentPath, mailboxSession);
            return MailboxPath.forUser((Username)mailboxSession.getUser(), (String)(parentPath.getName() + mailboxSession.getPathDelimiter() + mailboxRequest.getName()));
        }
        return MailboxPath.forUser((Username)mailboxSession.getUser(), (String)mailboxRequest.getName());
    }

    private void assertBelongsToUser(MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxNotOwnedException {
        if (!mailboxPath.belongsTo(mailboxSession)) {
            throw new MailboxNotOwnedException();
        }
    }

    private MailboxPath getMailboxPath(Map<MailboxCreationId, MailboxId> creationIdsToCreatedMailboxId, MailboxSession mailboxSession, MailboxCreationId parentId) throws MailboxException {
        Optional<MailboxId> mailboxId = this.readCreationIdAsMailboxId(parentId).or(() -> Optional.ofNullable((MailboxId)creationIdsToCreatedMailboxId.get(parentId)));
        return this.getMailboxPathFromId(mailboxId, mailboxSession).orElseThrow(() -> new MailboxParentNotFoundException(parentId));
    }

    private Optional<MailboxId> readCreationIdAsMailboxId(MailboxCreationId creationId) {
        try {
            return Optional.of(this.mailboxIdFactory.fromString(creationId.getCreationId()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @VisibleForTesting
    Optional<MailboxPath> getMailboxPathFromId(Optional<MailboxId> mailboxId, MailboxSession mailboxSession) {
        FunctionChainer fromMailboxIdToMailboxPath = Throwing.function(id -> {
            try {
                return Optional.of(this.mailboxManager.getMailbox(id, mailboxSession).getMailboxPath());
            }
            catch (MailboxNotFoundException e) {
                return Optional.empty();
            }
        });
        return mailboxId.flatMap(fromMailboxIdToMailboxPath.sneakyThrow());
    }
}

