/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.mailets.MappingArgument;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAttributesListToMimeHeaders
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAttributesListToMimeHeaders.class);
    private Map<AttributeName, String> attributeNameToHeader;

    public void init() throws MessagingException {
        String simpleMappings = this.getInitParameter("simplemapping");
        if (Strings.isNullOrEmpty((String)simpleMappings)) {
            throw new MessagingException("simplemapping is required");
        }
        this.attributeNameToHeader = (Map)MappingArgument.parse(simpleMappings).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> AttributeName.of((String)((String)entry.getKey())), Map.Entry::getValue));
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        this.attributeNameToHeader.entrySet().forEach(entry -> this.addAttributeToHeader(mail, message, (Map.Entry<AttributeName, String>)entry));
        message.saveChanges();
    }

    private void addAttributeToHeader(Mail mail, MimeMessage message, Map.Entry<AttributeName, String> entry) {
        AttributeUtils.getAttributeValueFromMail((Mail)mail, (AttributeName)entry.getKey()).ifPresent(attribute -> {
            if (attribute instanceof Collection) {
                Collection values = (Collection)attribute;
                values.forEach(value -> this.addValueToHeader(message, (String)entry.getValue(), value.getValue()));
            } else {
                LOGGER.warn("Can not add {} to headers. Expecting class Collection but got {}.", attribute, attribute.getClass());
            }
        });
    }

    private void addValueToHeader(MimeMessage message, String headerName, Object value) {
        try {
            if (value instanceof String) {
                message.addHeader(headerName, (String)value);
            } else if (value != null) {
                LOGGER.warn("Invalid type for value intended to be added as {} header. Expecting String but got {}", (Object)headerName, value.getClass());
            }
        }
        catch (MessagingException e) {
            LOGGER.warn("Could not add header {} with value {}", (Object)headerName, value);
        }
    }
}

