/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultTopologyMonitor;
import com.datastax.oss.driver.internal.core.metadata.SniEndPoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.UUID;

public class CloudTopologyMonitor
extends DefaultTopologyMonitor {
    private final InetSocketAddress cloudProxyAddress;

    public CloudTopologyMonitor(InternalDriverContext context, InetSocketAddress cloudProxyAddress) {
        super(context);
        this.cloudProxyAddress = cloudProxyAddress;
    }

    @Override
    @NonNull
    protected EndPoint buildNodeEndPoint(@NonNull AdminRow row, @Nullable InetSocketAddress broadcastRpcAddress, @NonNull EndPoint localEndPoint) {
        UUID hostId = Objects.requireNonNull(row.getUuid("host_id"));
        return new SniEndPoint(this.cloudProxyAddress, hostId.toString());
    }
}

