/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import org.apache.james.jdkim.DKIMCommon;
import org.apache.james.jdkim.api.BodyHasher;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.codec.binary.Base64;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.impl.BodyHasherImpl;
import org.apache.james.jdkim.impl.Message;
import org.apache.james.jdkim.tagvalue.SignatureRecordImpl;

public class DKIMSigner
extends DKIMCommon {
    private final PrivateKey privateKey;
    private final String signatureRecordTemplate;

    public DKIMSigner(String signatureRecordTemplate, PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.signatureRecordTemplate = signatureRecordTemplate;
    }

    public SignatureRecord newSignatureRecordTemplate(String record) {
        return new SignatureRecordImpl(record);
    }

    public BodyHasher newBodyHasher(SignatureRecord signRecord) throws PermFailException {
        return new BodyHasherImpl(signRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sign(InputStream is) throws IOException, FailException {
        try {
            Message message;
            try {
                message = new Message(is);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e1) {
                throw new PermFailException("MIME parsing exception: " + e1.getMessage(), e1);
            }
            try {
                SignatureRecord srt = this.newSignatureRecordTemplate(this.signatureRecordTemplate);
                BodyHasher bhj = this.newBodyHasher(srt);
                DKIMCommon.streamCopy(message.getBodyInputStream(), bhj.getOutputStream());
                String string = this.sign(message, bhj);
                message.dispose();
                return string;
            }
            catch (Throwable throwable) {
                message.dispose();
                throw throwable;
            }
        }
        finally {
            is.close();
        }
    }

    public String sign(Headers message, BodyHasher bh) throws PermFailException {
        if (!(bh instanceof BodyHasherImpl)) {
            throw new PermFailException("Supplied BodyHasher has not been generated with this signer");
        }
        BodyHasherImpl bhj = (BodyHasherImpl)bh;
        byte[] computedHash = bhj.getDigest();
        bhj.getSignatureRecord().setBodyHash(computedHash);
        List<CharSequence> headers = bhj.getSignatureRecord().getHeaders();
        try {
            byte[] signatureHash = this.signatureSign(message, bhj.getSignatureRecord(), this.privateKey, headers);
            bhj.getSignatureRecord().setSignature(signatureHash);
            return "DKIM-Signature:" + bhj.getSignatureRecord().toString();
        }
        catch (InvalidKeyException e) {
            throw new PermFailException("Invalid key: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PermFailException("Unknown algorythm: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new PermFailException("Signing exception: " + e.getMessage(), e);
        }
    }

    private byte[] signatureSign(Headers h, SignatureRecord sign, PrivateKey key, List<CharSequence> headers) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, PermFailException {
        Signature signature = Signature.getInstance(sign.getHashMethod().toString().toUpperCase() + "with" + sign.getHashKeyType().toString().toUpperCase());
        signature.initSign(key);
        DKIMSigner.signatureCheck(h, sign, headers, signature);
        return signature.sign();
    }

    public static PrivateKey getPrivateKey(String privateKeyPKCS8) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encKey = Base64.decodeBase64(privateKeyPKCS8.getBytes());
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(encKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(privSpec);
    }
}

