/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.scalar;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.helper.CastFunctionHelper;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.BooleanColumnBuilder;
import org.apache.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.tsfile.read.common.block.column.FloatColumnBuilder;
import org.apache.tsfile.read.common.block.column.IntColumnBuilder;
import org.apache.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;

public class CastFunctionTransformer
extends UnaryTransformer {
    private final TSDataType targetDataType;

    public CastFunctionTransformer(LayerReader layerReader, TSDataType targetDataType) {
        super(layerReader);
        this.targetDataType = targetDataType;
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{this.targetDataType};
    }

    @Override
    protected Column[] transform(Column[] columns) throws QueryProcessException, IOException {
        switch (this.layerReaderDataType) {
            case INT32: {
                return this.castInts(columns);
            }
            case INT64: {
                return this.castLongs(columns);
            }
            case FLOAT: {
                return this.castFloats(columns);
            }
            case DOUBLE: {
                return this.castDoubles(columns);
            }
            case BOOLEAN: {
                return this.castBooleans(columns);
            }
            case TEXT: {
                return this.castBinaries(columns);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported source dataType: %s", this.layerReaderDataType));
    }

    private Column[] castInts(Column[] columns) {
        LongColumnBuilder builder;
        if (this.targetDataType == TSDataType.INT32) {
            return columns;
        }
        int count = columns[0].getPositionCount();
        int[] values = columns[0].getInts();
        boolean[] isNulls = columns[0].isNull();
        switch (this.targetDataType) {
            case INT64: {
                int i;
                builder = new LongColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeLong((long)values[i]);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case FLOAT: {
                int i;
                builder = new FloatColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeFloat((float)values[i]);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case DOUBLE: {
                int i;
                builder = new DoubleColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeDouble((double)values[i]);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case BOOLEAN: {
                int i;
                builder = new BooleanColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeBoolean(values[i] != 0);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case TEXT: {
                int i;
                builder = new BinaryColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeBinary(BytesUtils.valueOf((String)String.valueOf(values[i])));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerReaderDataType));
            }
        }
        Column valueColumn = builder.build();
        Column timeColumn = columns[1];
        return new Column[]{valueColumn, timeColumn};
    }

    private Column[] castLongs(Column[] columns) {
        IntColumnBuilder builder;
        if (this.targetDataType == TSDataType.INT64) {
            return columns;
        }
        int count = columns[0].getPositionCount();
        long[] values = columns[0].getLongs();
        boolean[] isNulls = columns[0].isNull();
        switch (this.targetDataType) {
            case INT32: {
                int i;
                builder = new IntColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeInt(CastFunctionHelper.castLongToInt(values[i]));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case FLOAT: {
                int i;
                builder = new FloatColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeFloat((float)values[i]);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case DOUBLE: {
                int i;
                builder = new DoubleColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeDouble((double)values[i]);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case BOOLEAN: {
                int i;
                builder = new BooleanColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeBoolean(values[i] != 0L);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case TEXT: {
                int i;
                builder = new BinaryColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeBinary(BytesUtils.valueOf((String)String.valueOf(values[i])));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerReaderDataType));
            }
        }
        Column valueColumn = builder.build();
        Column timeColumn = columns[1];
        return new Column[]{valueColumn, timeColumn};
    }

    private Column[] castFloats(Column[] columns) {
        IntColumnBuilder builder;
        if (this.targetDataType == TSDataType.FLOAT) {
            return columns;
        }
        int count = columns[0].getPositionCount();
        float[] values = columns[0].getFloats();
        boolean[] isNulls = columns[0].isNull();
        switch (this.targetDataType) {
            case INT32: {
                int i;
                builder = new IntColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeInt(CastFunctionHelper.castFloatToInt(values[i]));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case INT64: {
                int i;
                builder = new LongColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeLong(CastFunctionHelper.castFloatToLong(values[i]));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case DOUBLE: {
                int i;
                builder = new DoubleColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeDouble((double)values[i]);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case BOOLEAN: {
                int i;
                builder = new BooleanColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeBoolean(values[i] != 0.0f);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case TEXT: {
                int i;
                builder = new BinaryColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeBinary(BytesUtils.valueOf((String)String.valueOf(values[i])));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerReaderDataType));
            }
        }
        Column valueColumn = builder.build();
        Column timeColumn = columns[1];
        return new Column[]{valueColumn, timeColumn};
    }

    private Column[] castDoubles(Column[] columns) {
        IntColumnBuilder builder;
        if (this.targetDataType == TSDataType.DOUBLE) {
            return columns;
        }
        int count = columns[0].getPositionCount();
        double[] values = columns[0].getDoubles();
        boolean[] isNulls = columns[0].isNull();
        switch (this.targetDataType) {
            case INT32: {
                int i;
                builder = new IntColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeInt(CastFunctionHelper.castDoubleToInt(values[i]));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case INT64: {
                int i;
                builder = new LongColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeLong(CastFunctionHelper.castDoubleToLong(values[i]));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case FLOAT: {
                int i;
                builder = new FloatColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeFloat(CastFunctionHelper.castDoubleToFloat(values[i]));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case BOOLEAN: {
                int i;
                builder = new BooleanColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeBoolean(values[i] != 0.0);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case TEXT: {
                int i;
                builder = new BinaryColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeBinary(BytesUtils.valueOf((String)String.valueOf(values[i])));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerReaderDataType));
            }
        }
        Column valueColumn = builder.build();
        Column timeColumn = columns[1];
        return new Column[]{valueColumn, timeColumn};
    }

    private Column[] castBooleans(Column[] columns) {
        IntColumnBuilder builder;
        if (this.targetDataType == TSDataType.BOOLEAN) {
            return columns;
        }
        int count = columns[0].getPositionCount();
        boolean[] values = columns[0].getBooleans();
        boolean[] isNulls = columns[0].isNull();
        switch (this.targetDataType) {
            case INT32: {
                int i;
                builder = new IntColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeInt(values[i] ? 1 : 0);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case INT64: {
                int i;
                builder = new LongColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeLong(values[i] ? 1L : 0L);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case FLOAT: {
                int i;
                builder = new FloatColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeFloat(values[i] ? 1.0f : 0.0f);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case DOUBLE: {
                int i;
                builder = new DoubleColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeDouble(values[i] ? 1.0 : 0.0);
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case TEXT: {
                int i;
                builder = new BinaryColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        builder.writeBinary(BytesUtils.valueOf((String)String.valueOf(values[i])));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerReaderDataType));
            }
        }
        Column valueColumn = builder.build();
        Column timeColumn = columns[1];
        return new Column[]{valueColumn, timeColumn};
    }

    private Column[] castBinaries(Column[] columns) {
        IntColumnBuilder builder;
        if (this.targetDataType == TSDataType.TEXT) {
            return columns;
        }
        int count = columns[0].getPositionCount();
        Binary[] values = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        switch (this.targetDataType) {
            case INT32: {
                String str;
                int i;
                builder = new IntColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        str = values[i].getStringValue(TSFileConfig.STRING_CHARSET);
                        builder.writeInt(Integer.parseInt(str));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case INT64: {
                String str;
                int i;
                builder = new LongColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        str = values[i].getStringValue(TSFileConfig.STRING_CHARSET);
                        builder.writeLong(Long.parseLong(str));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case FLOAT: {
                String str;
                int i;
                builder = new FloatColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        str = values[i].getStringValue(TSFileConfig.STRING_CHARSET);
                        builder.writeFloat(CastFunctionHelper.castTextToFloat(str));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case DOUBLE: {
                String str;
                int i;
                builder = new DoubleColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        str = values[i].getStringValue(TSFileConfig.STRING_CHARSET);
                        builder.writeDouble(CastFunctionHelper.castTextToDouble(str).doubleValue());
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            case BOOLEAN: {
                String str;
                int i;
                builder = new BooleanColumnBuilder(null, count);
                for (i = 0; i < count; ++i) {
                    if (!isNulls[i]) {
                        str = values[i].getStringValue(TSFileConfig.STRING_CHARSET);
                        builder.writeBoolean(CastFunctionHelper.castTextToBoolean(str));
                        continue;
                    }
                    builder.appendNull();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.layerReaderDataType));
            }
        }
        Column valueColumn = builder.build();
        Column timeColumn = columns[1];
        return new Column[]{valueColumn, timeColumn};
    }
}

