/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class DeleteMonitoredItemsRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=779");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=781");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=780");
    private final RequestHeader requestHeader;
    private final UInteger subscriptionId;
    private final UInteger[] monitoredItemIds;

    public DeleteMonitoredItemsRequest(RequestHeader requestHeader, UInteger subscriptionId, UInteger[] monitoredItemIds) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.monitoredItemIds = monitoredItemIds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public UInteger[] getMonitoredItemIds() {
        return this.monitoredItemIds;
    }

    protected DeleteMonitoredItemsRequest(DeleteMonitoredItemsRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((DeleteMonitoredItemsRequestBuilder)b).requestHeader;
        this.subscriptionId = ((DeleteMonitoredItemsRequestBuilder)b).subscriptionId;
        this.monitoredItemIds = ((DeleteMonitoredItemsRequestBuilder)b).monitoredItemIds;
    }

    public static DeleteMonitoredItemsRequestBuilder<?, ?> builder() {
        return new DeleteMonitoredItemsRequestBuilderImpl();
    }

    public DeleteMonitoredItemsRequestBuilder<?, ?> toBuilder() {
        return new DeleteMonitoredItemsRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteMonitoredItemsRequest)) {
            return false;
        }
        DeleteMonitoredItemsRequest other = (DeleteMonitoredItemsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        return Arrays.deepEquals(this.getMonitoredItemIds(), other.getMonitoredItemIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteMonitoredItemsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMonitoredItemIds());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteMonitoredItemsRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionId=" + this.getSubscriptionId() + ", monitoredItemIds=" + Arrays.deepToString(this.getMonitoredItemIds()) + ")";
    }

    private static final class DeleteMonitoredItemsRequestBuilderImpl
    extends DeleteMonitoredItemsRequestBuilder<DeleteMonitoredItemsRequest, DeleteMonitoredItemsRequestBuilderImpl> {
        private DeleteMonitoredItemsRequestBuilderImpl() {
        }

        @Override
        protected DeleteMonitoredItemsRequestBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteMonitoredItemsRequest build() {
            return new DeleteMonitoredItemsRequest(this);
        }
    }

    public static abstract class DeleteMonitoredItemsRequestBuilder<C extends DeleteMonitoredItemsRequest, B extends DeleteMonitoredItemsRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger subscriptionId;
        private UInteger[] monitoredItemIds;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteMonitoredItemsRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DeleteMonitoredItemsRequest instance, DeleteMonitoredItemsRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionId(instance.subscriptionId);
            b.monitoredItemIds(instance.monitoredItemIds);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B monitoredItemIds(UInteger[] monitoredItemIds) {
            this.monitoredItemIds = monitoredItemIds;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DeleteMonitoredItemsRequest.DeleteMonitoredItemsRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionId=" + this.subscriptionId + ", monitoredItemIds=" + Arrays.deepToString(this.monitoredItemIds) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteMonitoredItemsRequest> {
        @Override
        public Class<DeleteMonitoredItemsRequest> getType() {
            return DeleteMonitoredItemsRequest.class;
        }

        @Override
        public DeleteMonitoredItemsRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            UInteger[] monitoredItemIds = decoder.readUInt32Array("MonitoredItemIds");
            return new DeleteMonitoredItemsRequest(requestHeader, subscriptionId, monitoredItemIds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteMonitoredItemsRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeUInt32Array("MonitoredItemIds", value.getMonitoredItemIds());
        }
    }
}

