/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.config;

import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.enums.PipeRateAverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfig {
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfig.class);

    public String getPipeHardlinkBaseDirName() {
        return COMMON_CONFIG.getPipeHardlinkBaseDirName();
    }

    public String getPipeHardlinkTsFileDirName() {
        return COMMON_CONFIG.getPipeHardlinkTsFileDirName();
    }

    public boolean getPipeFileReceiverFsyncEnabled() {
        return COMMON_CONFIG.getPipeFileReceiverFsyncEnabled();
    }

    public int getPipeDataStructureTabletRowSize() {
        return COMMON_CONFIG.getPipeDataStructureTabletRowSize();
    }

    public int getPipeDataStructureTabletSizeInBytes() {
        return COMMON_CONFIG.getPipeDataStructureTabletSizeInBytes();
    }

    public double getPipeDataStructureTabletMemoryBlockAllocationRejectThreshold() {
        return COMMON_CONFIG.getPipeDataStructureTabletMemoryBlockAllocationRejectThreshold();
    }

    public double getPipeDataStructureTsFileMemoryBlockAllocationRejectThreshold() {
        return COMMON_CONFIG.getPipeDataStructureTsFileMemoryBlockAllocationRejectThreshold();
    }

    public double getPipeTotalFloatingMemoryProportion() {
        return COMMON_CONFIG.getPipeTotalFloatingMemoryProportion();
    }

    public boolean isPipeEnableMemoryCheck() {
        return COMMON_CONFIG.isPipeEnableMemoryChecked();
    }

    public long getPipeInsertNodeQueueMemory() {
        return COMMON_CONFIG.getPipeInsertNodeQueueMemory();
    }

    public long getTsFileParserMemory() {
        return COMMON_CONFIG.getPipeTsFileParserMemory();
    }

    public long getSinkBatchMemoryInsertNode() {
        return COMMON_CONFIG.getPipeSinkBatchMemoryInsertNode();
    }

    public long getSinkBatchMemoryTsFile() {
        return COMMON_CONFIG.getPipeSinkBatchMemoryTsFile();
    }

    public long getSendTsFileReadBuffer() {
        return COMMON_CONFIG.getPipeSendTsFileReadBuffer();
    }

    public double getReservedMemoryPercentage() {
        return COMMON_CONFIG.getPipeReservedMemoryPercentage();
    }

    public long getPipeMinimumReceiverMemory() {
        return COMMON_CONFIG.getPipeMinimumReceiverMemory();
    }

    public int getPipeRealTimeQueuePollTsFileThreshold() {
        return COMMON_CONFIG.getPipeRealTimeQueuePollTsFileThreshold();
    }

    public int getPipeRealTimeQueuePollHistoricalTsFileThreshold() {
        return Math.max(COMMON_CONFIG.getPipeRealTimeQueuePollHistoricalTsFileThreshold(), 1);
    }

    public int getPipeRealTimeQueueMaxWaitingTsFileSize() {
        return COMMON_CONFIG.getPipeRealTimeQueueMaxWaitingTsFileSize();
    }

    public int getPipeSubtaskExecutorMaxThreadNum() {
        return COMMON_CONFIG.getPipeSubtaskExecutorMaxThreadNum();
    }

    public int getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount() {
        return COMMON_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount();
    }

    public long getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration() {
        return COMMON_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration();
    }

    public long getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs() {
        return COMMON_CONFIG.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs();
    }

    public long getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds() {
        return COMMON_CONFIG.getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds();
    }

    public long getPipeMaxWaitFinishTime() {
        return COMMON_CONFIG.getPipeMaxWaitFinishTime();
    }

    public long getPipeSinkSubtaskSleepIntervalInitMs() {
        return COMMON_CONFIG.getPipeSinkSubtaskSleepIntervalInitMs();
    }

    public long getPipeSinkSubtaskSleepIntervalMaxMs() {
        return COMMON_CONFIG.getPipeSinkSubtaskSleepIntervalMaxMs();
    }

    public int getPipeSourceAssignerDisruptorRingBufferSize() {
        return COMMON_CONFIG.getPipeSourceAssignerDisruptorRingBufferSize();
    }

    public long getPipeSourceAssignerDisruptorRingBufferEntrySizeInBytes() {
        return COMMON_CONFIG.getPipeSourceAssignerDisruptorRingBufferEntrySizeInBytes();
    }

    public long getPipeSourceMatcherCacheSize() {
        return COMMON_CONFIG.getPipeSourceMatcherCacheSize();
    }

    public int getPipeSinkHandshakeTimeoutMs() {
        return COMMON_CONFIG.getPipeSinkHandshakeTimeoutMs();
    }

    public int getPipeConnectorTransferTimeoutMs() {
        return COMMON_CONFIG.getPipeConnectorTransferTimeoutMs();
    }

    public int getPipeConnectorReadFileBufferSize() {
        return COMMON_CONFIG.getPipeConnectorReadFileBufferSize();
    }

    public boolean isPipeConnectorReadFileBufferMemoryControlEnabled() {
        return COMMON_CONFIG.isPipeConnectorReadFileBufferMemoryControlEnabled();
    }

    public long getPipeConnectorRetryIntervalMs() {
        return COMMON_CONFIG.getPipeConnectorRetryIntervalMs();
    }

    public boolean isPipeConnectorRPCThriftCompressionEnabled() {
        return COMMON_CONFIG.isPipeConnectorRPCThriftCompressionEnabled();
    }

    public int getPipeAsyncSinkForcedRetryTsFileEventQueueSize() {
        return COMMON_CONFIG.getPipeAsyncSinkForcedRetryTsFileEventQueueSize();
    }

    public int getPipeAsyncSinkForcedRetryTabletEventQueueSize() {
        return COMMON_CONFIG.getPipeAsyncSinkForcedRetryTabletEventQueueSize();
    }

    public int getPipeAsyncSinkForcedRetryTotalEventQueueSize() {
        return COMMON_CONFIG.getPipeAsyncSinkForcedRetryTotalEventQueueSize();
    }

    public long getPipeAsyncConnectorMaxRetryExecutionTimeMsPerCall() {
        return COMMON_CONFIG.getPipeAsyncConnectorMaxRetryExecutionTimeMsPerCall();
    }

    public int getPipeAsyncConnectorSelectorNumber() {
        return COMMON_CONFIG.getPipeAsyncConnectorSelectorNumber();
    }

    public int getPipeAsyncConnectorMaxClientNumber() {
        return COMMON_CONFIG.getPipeAsyncConnectorMaxClientNumber();
    }

    public int getPipeAsyncConnectorMaxTsFileClientNumber() {
        return COMMON_CONFIG.getPipeAsyncConnectorMaxTsFileClientNumber();
    }

    public double getPipeSendTsFileRateLimitBytesPerSecond() {
        return COMMON_CONFIG.getPipeSendTsFileRateLimitBytesPerSecond();
    }

    public double getPipeAllConnectorsRateLimitBytesPerSecond() {
        return COMMON_CONFIG.getPipeAllSinksRateLimitBytesPerSecond();
    }

    public int getRateLimiterHotReloadCheckIntervalMs() {
        return COMMON_CONFIG.getRateLimiterHotReloadCheckIntervalMs();
    }

    public int getPipeConnectorRequestSliceThresholdBytes() {
        return COMMON_CONFIG.getPipeConnectorRequestSliceThresholdBytes();
    }

    public long getPipeMaxReaderChunkSize() {
        return COMMON_CONFIG.getPipeMaxReaderChunkSize();
    }

    public long getPipeRemainingTimeCommitAutoSwitchSeconds() {
        return COMMON_CONFIG.getPipeRemainingTimeCommitRateAutoSwitchSeconds();
    }

    public PipeRateAverage getPipeRemainingTimeCommitRateAverageTime() {
        return COMMON_CONFIG.getPipeRemainingTimeCommitRateAverageTime();
    }

    public double getPipeRemainingInsertNodeCountEMAAlpha() {
        return COMMON_CONFIG.getPipeRemainingInsertNodeCountEMAAlpha();
    }

    public double getPipeTsFileScanParsingThreshold() {
        return COMMON_CONFIG.getPipeTsFileScanParsingThreshold();
    }

    public double getPipeDynamicMemoryHistoryWeight() {
        return COMMON_CONFIG.getPipeDynamicMemoryHistoryWeight();
    }

    public double getPipeDynamicMemoryAdjustmentThreshold() {
        return COMMON_CONFIG.getPipeDynamicMemoryAdjustmentThreshold();
    }

    public double getPipeThresholdAllocationStrategyMaximumMemoryIncrementRatio() {
        return COMMON_CONFIG.getPipeThresholdAllocationStrategyMaximumMemoryIncrementRatio();
    }

    public double getPipeThresholdAllocationStrategyLowUsageThreshold() {
        return COMMON_CONFIG.getPipeThresholdAllocationStrategyLowUsageThreshold();
    }

    public double getPipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold() {
        return COMMON_CONFIG.getPipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold();
    }

    public boolean isTransferTsFileSync() {
        return COMMON_CONFIG.getPipeTransferTsFileSync();
    }

    public long getPipeCheckAllSyncClientLiveTimeIntervalMs() {
        return COMMON_CONFIG.getPipeCheckAllSyncClientLiveTimeIntervalMs();
    }

    public int getPipeTsFileResourceSegmentLockNum() {
        return COMMON_CONFIG.getPipeTsFileResourceSegmentLockNum();
    }

    public boolean isSeperatedPipeHeartbeatEnabled() {
        return COMMON_CONFIG.isSeperatedPipeHeartbeatEnabled();
    }

    public int getPipeHeartbeatIntervalSecondsForCollectingPipeMeta() {
        return COMMON_CONFIG.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta();
    }

    public long getPipeMetaSyncerInitialSyncDelayMinutes() {
        return COMMON_CONFIG.getPipeMetaSyncerInitialSyncDelayMinutes();
    }

    public long getPipeMetaSyncerSyncIntervalMinutes() {
        return COMMON_CONFIG.getPipeMetaSyncerSyncIntervalMinutes();
    }

    public long getPipeMetaSyncerAutoRestartPipeCheckIntervalRound() {
        return COMMON_CONFIG.getPipeMetaSyncerAutoRestartPipeCheckIntervalRound();
    }

    public boolean getPipeAutoRestartEnabled() {
        return COMMON_CONFIG.getPipeAutoRestartEnabled();
    }

    public boolean getPipeAirGapReceiverEnabled() {
        return COMMON_CONFIG.getPipeAirGapReceiverEnabled();
    }

    public int getPipeAirGapReceiverPort() {
        return COMMON_CONFIG.getPipeAirGapReceiverPort();
    }

    public long getPipeReceiverLoginPeriodicVerificationIntervalMs() {
        return COMMON_CONFIG.getPipeReceiverLoginPeriodicVerificationIntervalMs();
    }

    public double getPipeReceiverActualToEstimatedMemoryRatio() {
        return COMMON_CONFIG.getPipeReceiverActualToEstimatedMemoryRatio();
    }

    public int getPipeReceiverReqDecompressedMaxLengthInBytes() {
        return COMMON_CONFIG.getPipeReceiverReqDecompressedMaxLengthInBytes();
    }

    public boolean isPipeReceiverLoadConversionEnabled() {
        return COMMON_CONFIG.isPipeReceiverLoadConversionEnabled();
    }

    public long getPipePeriodicalLogMinIntervalSeconds() {
        return COMMON_CONFIG.getPipePeriodicalLogMinIntervalSeconds();
    }

    public boolean isPipeRetryLocallyForParallelOrUserConflict() {
        return COMMON_CONFIG.isPipeRetryLocallyForParallelOrUserConflict();
    }

    public double getPipeMetaReportMaxLogNumPerRound() {
        return COMMON_CONFIG.getPipeMetaReportMaxLogNumPerRound();
    }

    public int getPipeMetaReportMaxLogIntervalRounds() {
        return COMMON_CONFIG.getPipeMetaReportMaxLogIntervalRounds();
    }

    public int getPipeTsFilePinMaxLogNumPerRound() {
        return COMMON_CONFIG.getPipeTsFilePinMaxLogNumPerRound();
    }

    public int getPipeTsFilePinMaxLogIntervalRounds() {
        return COMMON_CONFIG.getPipeTsFilePinMaxLogIntervalRounds();
    }

    public long getPipeLoggerCacheMaxSizeInBytes() {
        return COMMON_CONFIG.getPipeLoggerCacheMaxSizeInBytes();
    }

    public boolean getPipeMemoryManagementEnabled() {
        return COMMON_CONFIG.getPipeMemoryManagementEnabled();
    }

    public int getPipeMemoryAllocateMaxRetries() {
        return COMMON_CONFIG.getPipeMemoryAllocateMaxRetries();
    }

    public long getPipeMemoryAllocateRetryIntervalInMs() {
        return COMMON_CONFIG.getPipeMemoryAllocateRetryIntervalInMs();
    }

    public long getPipeMemoryAllocateMinSizeInBytes() {
        return COMMON_CONFIG.getPipeMemoryAllocateMinSizeInBytes();
    }

    public long getPipeMemoryAllocateForTsFileSequenceReaderInBytes() {
        return COMMON_CONFIG.getPipeMemoryAllocateForTsFileSequenceReaderInBytes();
    }

    public long getPipeMemoryExpanderIntervalSeconds() {
        return COMMON_CONFIG.getPipeMemoryExpanderIntervalSeconds();
    }

    public long getPipeCheckMemoryEnoughIntervalMs() {
        return COMMON_CONFIG.getPipeCheckMemoryEnoughIntervalMs();
    }

    public float getPipeLeaderCacheMemoryUsagePercentage() {
        return COMMON_CONFIG.getPipeLeaderCacheMemoryUsagePercentage();
    }

    public long getTwoStageAggregateMaxCombinerLiveTimeInMs() {
        return COMMON_CONFIG.getTwoStageAggregateMaxCombinerLiveTimeInMs();
    }

    public long getTwoStageAggregateDataRegionInfoCacheTimeInMs() {
        return COMMON_CONFIG.getTwoStageAggregateDataRegionInfoCacheTimeInMs();
    }

    public long getTwoStageAggregateSenderEndPointsCacheInMs() {
        return COMMON_CONFIG.getTwoStageAggregateSenderEndPointsCacheInMs();
    }

    public long getPipeListeningQueueTransferSnapshotThreshold() {
        return COMMON_CONFIG.getPipeListeningQueueTransferSnapshotThreshold();
    }

    public int getPipeSnapshotExecutionMaxBatchSize() {
        return COMMON_CONFIG.getPipeSnapshotExecutionMaxBatchSize();
    }

    public boolean getPipeEventReferenceTrackingEnabled() {
        return COMMON_CONFIG.getPipeEventReferenceTrackingEnabled();
    }

    public long getPipeEventReferenceEliminateIntervalSeconds() {
        return COMMON_CONFIG.getPipeEventReferenceEliminateIntervalSeconds();
    }

    public boolean getPipeAutoSplitFullEnabled() {
        return COMMON_CONFIG.getPipeAutoSplitFullEnabled();
    }

    public void printAllConfigs() {
        LOGGER.info("PipeHardlinkBaseDirName: {}", (Object)this.getPipeHardlinkBaseDirName());
        LOGGER.info("PipeHardlinkTsFileDirName: {}", (Object)this.getPipeHardlinkTsFileDirName());
        LOGGER.info("PipeFileReceiverFsyncEnabled: {}", (Object)this.getPipeFileReceiverFsyncEnabled());
        LOGGER.info("PipeDataStructureTabletRowSize: {}", (Object)this.getPipeDataStructureTabletRowSize());
        LOGGER.info("PipeDataStructureTabletSizeInBytes: {}", (Object)this.getPipeDataStructureTabletSizeInBytes());
        LOGGER.info("PipeDataStructureTabletMemoryBlockAllocationRejectThreshold: {}", (Object)this.getPipeDataStructureTabletMemoryBlockAllocationRejectThreshold());
        LOGGER.info("PipeDataStructureTsFileMemoryBlockAllocationRejectThreshold: {}", (Object)this.getPipeDataStructureTsFileMemoryBlockAllocationRejectThreshold());
        LOGGER.info("PipeTotalFloatingMemoryProportion: {}", (Object)this.getPipeTotalFloatingMemoryProportion());
        LOGGER.info("IsPipeEnableMemoryCheck: {}", (Object)this.isPipeEnableMemoryCheck());
        LOGGER.info("PipeTsFileParserMemory: {}", (Object)this.getTsFileParserMemory());
        LOGGER.info("SinkBatchMemoryInsertNode: {}", (Object)this.getSinkBatchMemoryInsertNode());
        LOGGER.info("SinkBatchMemoryTsFile: {}", (Object)this.getSinkBatchMemoryTsFile());
        LOGGER.info("SendTsFileReadBuffer: {}", (Object)this.getSendTsFileReadBuffer());
        LOGGER.info("PipeReservedMemoryPercentage: {}", (Object)this.getReservedMemoryPercentage());
        LOGGER.info("PipeMinimumReceiverMemory: {}", (Object)this.getPipeMinimumReceiverMemory());
        LOGGER.info("PipeRealTimeQueuePollTsFileThreshold: {}", (Object)this.getPipeRealTimeQueuePollTsFileThreshold());
        LOGGER.info("PipeRealTimeQueuePollHistoricalTsFileThreshold: {}", (Object)this.getPipeRealTimeQueuePollHistoricalTsFileThreshold());
        LOGGER.info("PipeSubtaskExecutorMaxThreadNum: {}", (Object)this.getPipeSubtaskExecutorMaxThreadNum());
        LOGGER.info("PipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount: {}", (Object)this.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount());
        LOGGER.info("PipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration: {}", (Object)this.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration());
        LOGGER.info("PipeSubtaskExecutorPendingQueueMaxBlockingTimeMs: {}", (Object)this.getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs());
        LOGGER.info("PipeSubtaskExecutorCronHeartbeatEventIntervalSeconds: {}", (Object)this.getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds());
        LOGGER.info("PipeMaxWaitFinishTime: {}", (Object)this.getPipeMaxWaitFinishTime());
        LOGGER.info("PipeSinkSubtaskSleepIntervalInitMs: {}", (Object)this.getPipeSinkSubtaskSleepIntervalInitMs());
        LOGGER.info("PipeSinkSubtaskSleepIntervalMaxMs: {}", (Object)this.getPipeSinkSubtaskSleepIntervalMaxMs());
        LOGGER.info("PipeSourceAssignerDisruptorRingBufferSize: {}", (Object)this.getPipeSourceAssignerDisruptorRingBufferSize());
        LOGGER.info("PipeSourceAssignerDisruptorRingBufferEntrySizeInBytes: {}", (Object)this.getPipeSourceAssignerDisruptorRingBufferEntrySizeInBytes());
        LOGGER.info("PipeSourceMatcherCacheSize: {}", (Object)this.getPipeSourceMatcherCacheSize());
        LOGGER.info("PipeConnectorHandshakeTimeoutMs: {}", (Object)this.getPipeSinkHandshakeTimeoutMs());
        LOGGER.info("PipeConnectorTransferTimeoutMs: {}", (Object)this.getPipeConnectorTransferTimeoutMs());
        LOGGER.info("PipeConnectorReadFileBufferSize: {}", (Object)this.getPipeConnectorReadFileBufferSize());
        LOGGER.info("PipeConnectorReadFileBufferMemoryControlEnabled: {}", (Object)this.isPipeConnectorReadFileBufferMemoryControlEnabled());
        LOGGER.info("PipeConnectorRetryIntervalMs: {}", (Object)this.getPipeConnectorRetryIntervalMs());
        LOGGER.info("PipeConnectorRPCThriftCompressionEnabled: {}", (Object)this.isPipeConnectorRPCThriftCompressionEnabled());
        LOGGER.info("PipeLeaderCacheMemoryUsagePercentage: {}", (Object)Float.valueOf(this.getPipeLeaderCacheMemoryUsagePercentage()));
        LOGGER.info("PipeReaderChunkSize: {}", (Object)this.getPipeMaxReaderChunkSize());
        LOGGER.info("PipeListeningQueueTransferSnapshotThreshold: {}", (Object)this.getPipeListeningQueueTransferSnapshotThreshold());
        LOGGER.info("PipeSnapshotExecutionMaxBatchSize: {}", (Object)this.getPipeSnapshotExecutionMaxBatchSize());
        LOGGER.info("PipeRemainingTimeCommitAutoSwitchSeconds: {}", (Object)this.getPipeRemainingTimeCommitAutoSwitchSeconds());
        LOGGER.info("PipeRemainingTimeCommitRateAverageTime: {}", (Object)this.getPipeRemainingTimeCommitRateAverageTime());
        LOGGER.info("PipePipeRemainingInsertEventCountAverage: {}", (Object)this.getPipeRemainingInsertNodeCountEMAAlpha());
        LOGGER.info("PipeTsFileScanParsingThreshold(): {}", (Object)this.getPipeTsFileScanParsingThreshold());
        LOGGER.info("PipeTransferTsFileSync: {}", (Object)this.isTransferTsFileSync());
        LOGGER.info("PipeCheckAllSyncClientLiveTimeIntervalMs: {}", (Object)this.getPipeCheckAllSyncClientLiveTimeIntervalMs());
        LOGGER.info("PipeCheckAllSyncClientLiveTimeIntervalMs: {}", (Object)this.getPipeCheckAllSyncClientLiveTimeIntervalMs());
        LOGGER.info("PipeDynamicMemoryHistoryWeight: {}", (Object)this.getPipeDynamicMemoryHistoryWeight());
        LOGGER.info("PipeDynamicMemoryAdjustmentThreshold: {}", (Object)this.getPipeDynamicMemoryAdjustmentThreshold());
        LOGGER.info("PipeThresholdAllocationStrategyMaximumMemoryIncrementRatio: {}", (Object)this.getPipeThresholdAllocationStrategyMaximumMemoryIncrementRatio());
        LOGGER.info("PipeThresholdAllocationStrategyLowUsageThreshold: {}", (Object)this.getPipeThresholdAllocationStrategyLowUsageThreshold());
        LOGGER.info("PipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold: {}", (Object)this.getPipeThresholdAllocationStrategyFixedMemoryHighUsageThreshold());
        LOGGER.info("PipeAsyncSinkForcedRetryTsFileEventQueueSize: {}", (Object)this.getPipeAsyncSinkForcedRetryTsFileEventQueueSize());
        LOGGER.info("PipeAsyncSinkForcedRetryTabletEventQueueSize: {}", (Object)this.getPipeAsyncSinkForcedRetryTabletEventQueueSize());
        LOGGER.info("PipeAsyncSinkForcedRetryTotalEventQueueSize: {}", (Object)this.getPipeAsyncSinkForcedRetryTotalEventQueueSize());
        LOGGER.info("PipeAsyncConnectorMaxRetryExecutionTimeMsPerCall: {}", (Object)this.getPipeAsyncConnectorMaxRetryExecutionTimeMsPerCall());
        LOGGER.info("PipeAsyncConnectorSelectorNumber: {}", (Object)this.getPipeAsyncConnectorSelectorNumber());
        LOGGER.info("PipeAsyncConnectorMaxClientNumber: {}", (Object)this.getPipeAsyncConnectorMaxClientNumber());
        LOGGER.info("PipeAsyncConnectorMaxTsFileClientNumber: {}", (Object)this.getPipeAsyncConnectorMaxTsFileClientNumber());
        LOGGER.info("PipeSendTsFileRateLimitBytesPerSecond: {}", (Object)this.getPipeSendTsFileRateLimitBytesPerSecond());
        LOGGER.info("PipeAllConnectorsRateLimitBytesPerSecond: {}", (Object)this.getPipeAllConnectorsRateLimitBytesPerSecond());
        LOGGER.info("RateLimiterHotReloadCheckIntervalMs: {}", (Object)this.getRateLimiterHotReloadCheckIntervalMs());
        LOGGER.info("PipeConnectorRequestSliceThresholdBytes: {}", (Object)this.getPipeConnectorRequestSliceThresholdBytes());
        LOGGER.info("SeperatedPipeHeartbeatEnabled: {}", (Object)this.isSeperatedPipeHeartbeatEnabled());
        LOGGER.info("PipeHeartbeatIntervalSecondsForCollectingPipeMeta: {}", (Object)this.getPipeHeartbeatIntervalSecondsForCollectingPipeMeta());
        LOGGER.info("PipeMetaSyncerInitialSyncDelayMinutes: {}", (Object)this.getPipeMetaSyncerInitialSyncDelayMinutes());
        LOGGER.info("PipeMetaSyncerSyncIntervalMinutes: {}", (Object)this.getPipeMetaSyncerSyncIntervalMinutes());
        LOGGER.info("PipeMetaSyncerAutoRestartPipeCheckIntervalRound: {}", (Object)this.getPipeMetaSyncerAutoRestartPipeCheckIntervalRound());
        LOGGER.info("PipeAutoRestartEnabled: {}", (Object)this.getPipeAutoRestartEnabled());
        LOGGER.info("PipeAirGapReceiverEnabled: {}", (Object)this.getPipeAirGapReceiverEnabled());
        LOGGER.info("PipeAirGapReceiverPort: {}", (Object)this.getPipeAirGapReceiverPort());
        LOGGER.info("PipeReceiverLoginPeriodicVerificationIntervalMs: {}", (Object)this.getPipeReceiverLoginPeriodicVerificationIntervalMs());
        LOGGER.info("PipeReceiverActualToEstimatedMemoryRatio: {}", (Object)this.getPipeReceiverActualToEstimatedMemoryRatio());
        LOGGER.info("PipeReceiverReqDecompressedMaxLengthInBytes: {}", (Object)this.getPipeReceiverReqDecompressedMaxLengthInBytes());
        LOGGER.info("PipeReceiverLoadConversionEnabled: {}", (Object)this.isPipeReceiverLoadConversionEnabled());
        LOGGER.info("PipePeriodicalLogMinIntervalSeconds: {}", (Object)this.getPipePeriodicalLogMinIntervalSeconds());
        LOGGER.info("PipeRetryLocallyForParallelOrUserConflict: {}", (Object)this.isPipeRetryLocallyForParallelOrUserConflict());
        LOGGER.info("PipeMetaReportMaxLogNumPerRound: {}", (Object)this.getPipeMetaReportMaxLogNumPerRound());
        LOGGER.info("PipeMetaReportMaxLogIntervalRounds: {}", (Object)this.getPipeMetaReportMaxLogIntervalRounds());
        LOGGER.info("PipeTsFilePinMaxLogNumPerRound: {}", (Object)this.getPipeTsFilePinMaxLogNumPerRound());
        LOGGER.info("PipeTsFilePinMaxLogIntervalRounds: {}", (Object)this.getPipeTsFilePinMaxLogIntervalRounds());
        LOGGER.info("PipeLoggerCacheMaxSizeInBytes: {}", (Object)this.getPipeLoggerCacheMaxSizeInBytes());
        LOGGER.info("PipeMemoryManagementEnabled: {}", (Object)this.getPipeMemoryManagementEnabled());
        LOGGER.info("PipeMemoryAllocateMaxRetries: {}", (Object)this.getPipeMemoryAllocateMaxRetries());
        LOGGER.info("PipeMemoryAllocateRetryIntervalInMs: {}", (Object)this.getPipeMemoryAllocateRetryIntervalInMs());
        LOGGER.info("PipeMemoryAllocateMinSizeInBytes: {}", (Object)this.getPipeMemoryAllocateMinSizeInBytes());
        LOGGER.info("PipeMemoryAllocateForTsFileSequenceReaderInBytes: {}", (Object)this.getPipeMemoryAllocateForTsFileSequenceReaderInBytes());
        LOGGER.info("PipeMemoryExpanderIntervalSeconds: {}", (Object)this.getPipeMemoryExpanderIntervalSeconds());
        LOGGER.info("PipeCheckMemoryEnoughIntervalMs: {}", (Object)this.getPipeCheckMemoryEnoughIntervalMs());
        LOGGER.info("TwoStageAggregateMaxCombinerLiveTimeInMs: {}", (Object)this.getTwoStageAggregateMaxCombinerLiveTimeInMs());
        LOGGER.info("TwoStageAggregateDataRegionInfoCacheTimeInMs: {}", (Object)this.getTwoStageAggregateDataRegionInfoCacheTimeInMs());
        LOGGER.info("TwoStageAggregateSenderEndPointsCacheInMs: {}", (Object)this.getTwoStageAggregateSenderEndPointsCacheInMs());
        LOGGER.info("PipeEventReferenceTrackingEnabled: {}", (Object)this.getPipeEventReferenceTrackingEnabled());
        LOGGER.info("PipeEventReferenceEliminateIntervalSeconds: {}", (Object)this.getPipeEventReferenceEliminateIntervalSeconds());
        LOGGER.info("PipeAutoSplitFullEnabled: {}", (Object)this.getPipeAutoSplitFullEnabled());
    }

    private PipeConfig() {
    }

    public static PipeConfig getInstance() {
        return PipeConfigHolder.INSTANCE;
    }

    private static class PipeConfigHolder {
        private static final PipeConfig INSTANCE = new PipeConfig();

        private PipeConfigHolder() {
        }
    }
}

