/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.view.visitor;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.NotSupportedException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.BinaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.AdditionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.ArithmeticBinaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.DivisionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.ModuloViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.MultiplicationViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.SubtractionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.CompareBinaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.EqualToViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.GreaterEqualViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.GreaterThanViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.LessEqualViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.LessThanViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.NonEqualViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.logic.LogicAndViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.logic.LogicBinaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.logic.LogicOrViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.ConstantViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.LeafViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.NullViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimeSeriesViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimestampViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.multi.FunctionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ternary.BetweenViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ternary.TernaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.InViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.IsNullViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.LikeViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.LogicNotViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.NegationViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.RegularViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.UnaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.tsfile.utils.Pair;

public class TransformToExpressionVisitor
extends ViewExpressionVisitor<Expression, Void> {
    public Expression process(ViewExpression viewExpression, Void context) {
        return (Expression)viewExpression.accept((ViewExpressionVisitor)this, (Object)context);
    }

    public Expression visitExpression(ViewExpression expression, Void context) {
        throw new RuntimeException((Throwable)new NotSupportedException("visitExpression in TransformToExpressionVisitor is not supported."));
    }

    public Expression visitLeafOperand(LeafViewOperand leafViewOperand, Void context) {
        throw new RuntimeException((Throwable)new NotSupportedException("Can not construct abstract class."));
    }

    public Expression visitConstantOperand(ConstantViewOperand constantOperand, Void context) {
        return new ConstantOperand(constantOperand.getDataType(), constantOperand.getValueString());
    }

    public Expression visitNullOperand(NullViewOperand nullOperand, Void context) {
        return new NullOperand();
    }

    public Expression visitTimeSeriesOperand(TimeSeriesViewOperand timeSeriesOperand, Void context) {
        try {
            PartialPath path = new PartialPath(timeSeriesOperand.getPathString());
            return new TimeSeriesOperand(path);
        }
        catch (IllegalPathException e) {
            throw new RuntimeException(e);
        }
    }

    public Expression visitTimeStampOperand(TimestampViewOperand timestampOperand, Void context) {
        return new TimestampOperand();
    }

    public Expression visitUnaryExpression(UnaryViewExpression unaryViewExpression, Void context) {
        throw new RuntimeException((Throwable)new NotSupportedException("Can not construct abstract class."));
    }

    public Expression visitInExpression(InViewExpression inExpression, Void context) {
        Expression child = this.process(inExpression.getExpression(), context);
        return new InExpression(child, inExpression.isNotIn(), inExpression.getValuesInLinkedHashSet());
    }

    public Expression visitIsNullExpression(IsNullViewExpression isNullExpression, Void context) {
        Expression child = this.process(isNullExpression.getExpression(), context);
        return new IsNullExpression(child, isNullExpression.isNot());
    }

    public Expression visitLikeExpression(LikeViewExpression likeExpression, Void context) {
        Expression child = this.process(likeExpression.getExpression(), context);
        return new LikeExpression(child, likeExpression.getPatternString(), likeExpression.getPattern(), likeExpression.isNot());
    }

    public Expression visitLogicNotExpression(LogicNotViewExpression logicNotExpression, Void context) {
        Expression child = this.process(logicNotExpression.getExpression(), context);
        return new LogicNotExpression(child);
    }

    public Expression visitNegationExpression(NegationViewExpression negationExpression, Void context) {
        Expression child = this.process(negationExpression.getExpression(), context);
        return new NegationExpression(child);
    }

    public Expression visitRegularExpression(RegularViewExpression regularExpression, Void context) {
        Expression child = this.process(regularExpression.getExpression(), context);
        return new RegularExpression(child, regularExpression.getPatternString(), regularExpression.getPattern(), regularExpression.isNot());
    }

    public Expression visitBinaryExpression(BinaryViewExpression binaryViewExpression, Void context) {
        throw new RuntimeException((Throwable)new NotSupportedException("Can not construct abstract class."));
    }

    private Pair<Expression, Expression> getExpressionsForBinaryExpression(BinaryViewExpression binaryViewExpression) {
        Expression left = this.process(binaryViewExpression.getLeftExpression(), null);
        Expression right = this.process(binaryViewExpression.getRightExpression(), null);
        return new Pair((Object)left, (Object)right);
    }

    public Expression visitArithmeticBinaryExpression(ArithmeticBinaryViewExpression arithmeticBinaryExpression, Void context) {
        throw new RuntimeException((Throwable)new NotSupportedException("Can not construct abstract class."));
    }

    public Expression visitAdditionExpression(AdditionViewExpression additionExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)additionExpression);
        return new AdditionExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitDivisionExpression(DivisionViewExpression divisionExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)divisionExpression);
        return new DivisionExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitModuloExpression(ModuloViewExpression moduloExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)moduloExpression);
        return new ModuloExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitMultiplicationExpression(MultiplicationViewExpression multiplicationExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)multiplicationExpression);
        return new MultiplicationExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitSubtractionExpression(SubtractionViewExpression subtractionExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)subtractionExpression);
        return new SubtractionExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitCompareBinaryExpression(CompareBinaryViewExpression compareBinaryExpression, Void context) {
        throw new RuntimeException((Throwable)new NotSupportedException("Can not construct abstract class."));
    }

    public Expression visitEqualToExpression(EqualToViewExpression equalToExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)equalToExpression);
        return new EqualToExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitGreaterEqualExpression(GreaterEqualViewExpression greaterEqualExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)greaterEqualExpression);
        return new GreaterEqualExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitGreaterThanExpression(GreaterThanViewExpression greaterThanExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)greaterThanExpression);
        return new GreaterThanExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitLessEqualExpression(LessEqualViewExpression lessEqualExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)lessEqualExpression);
        return new LessEqualExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitLessThanExpression(LessThanViewExpression lessThanExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)lessThanExpression);
        return new LessThanExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitNonEqualExpression(NonEqualViewExpression nonEqualExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)nonEqualExpression);
        return new NonEqualExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitLogicBinaryExpression(LogicBinaryViewExpression logicBinaryExpression, Void context) {
        throw new RuntimeException((Throwable)new NotSupportedException("Can not construct abstract class."));
    }

    public Expression visitLogicAndExpression(LogicAndViewExpression logicAndExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)logicAndExpression);
        return new LogicAndExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitLogicOrExpression(LogicOrViewExpression logicOrExpression, Void context) {
        Pair<Expression, Expression> pair = this.getExpressionsForBinaryExpression((BinaryViewExpression)logicOrExpression);
        return new LogicOrExpression((Expression)pair.left, (Expression)pair.right);
    }

    public Expression visitTernaryExpression(TernaryViewExpression ternaryViewExpression, Void context) {
        throw new RuntimeException((Throwable)new NotSupportedException("Can not construct abstract class."));
    }

    public Expression visitBetweenExpression(BetweenViewExpression betweenViewExpression, Void context) {
        Expression first = this.process(betweenViewExpression.getFirstExpression(), null);
        Expression second = this.process(betweenViewExpression.getSecondExpression(), null);
        Expression third = this.process(betweenViewExpression.getThirdExpression(), null);
        return new BetweenExpression(first, second, third, betweenViewExpression.isNotBetween());
    }

    public Expression visitFunctionExpression(FunctionViewExpression functionViewExpression, Void context) {
        List viewExpressionList = functionViewExpression.getExpressions();
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (ViewExpression viewExpression : viewExpressionList) {
            expressionList.add(this.process(viewExpression, null));
        }
        return new FunctionExpression(functionViewExpression.getFunctionName(), functionViewExpression.getFunctionAttributes(), expressionList);
    }
}

