/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.security.encrypt;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.security.encrypt.AsymmetricEncrypt;
import org.apache.iotdb.commons.security.encrypt.EncryptDecryptException;

public class AsymmetricEncryptFactory {
    private static final AtomicReference<AsymmetricEncrypt> asymmetricEncrypt = new AtomicReference();

    private AsymmetricEncryptFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AsymmetricEncrypt getEncryptProvider(String providerClassName, String providerParameter) {
        if (asymmetricEncrypt.get() != null) return asymmetricEncrypt.get();
        Class<AsymmetricEncrypt> clazz = AsymmetricEncrypt.class;
        synchronized (AsymmetricEncrypt.class) {
            if (asymmetricEncrypt.get() != null) return asymmetricEncrypt.get();
            try {
                Class<?> providerClass = AsymmetricEncryptFactory.getClassLoaderForClass(AsymmetricEncrypt.class).loadClass(providerClassName);
                asymmetricEncrypt.set((AsymmetricEncrypt)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                asymmetricEncrypt.get().init(providerParameter);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new EncryptDecryptException(e);
            }
            return asymmetricEncrypt.get();
        }
    }

    private static ClassLoader getClassLoaderForClass(Class<?> c) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = c.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            throw new EncryptDecryptException("A ClassLoader to load the class could not be determined.");
        }
        return cl;
    }
}

