/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.connector.protocol;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBAirGapConnector;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigNodeHandshakeV1Req;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigNodeHandshakeV2Req;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigPlanReq;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigSnapshotPieceReq;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigSnapshotSealReq;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionSnapshotEvent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionWritePlanEvent;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfigRegionAirGapConnector
extends IoTDBAirGapConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConfigRegionAirGapConnector.class);

    protected byte[] generateHandShakeV1Payload() throws IOException {
        return PipeTransferConfigNodeHandshakeV1Req.toTPipeTransferBytes(CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
    }

    protected byte[] generateHandShakeV2Payload() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("clusterID", ConfigNode.getInstance().getConfigManager().getClusterManager().getClusterId());
        params.put("timestampPrecision", CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        params.put("convertOnTypeMismatch", Boolean.toString(this.shouldReceiverConvertOnTypeMismatch));
        params.put("loadTsFileStrategy", this.loadTsFileStrategy);
        params.put("username", this.username);
        params.put("password", this.password);
        params.put("validateTsFile", Boolean.toString(this.loadTsFileValidation));
        params.put("markAsPipeRequest", Boolean.toString(this.shouldMarkAsPipeRequest));
        return PipeTransferConfigNodeHandshakeV2Req.toTPipeTransferBytes(params);
    }

    protected boolean mayNeedHandshakeWhenFail() {
        return true;
    }

    protected byte[] getTransferSingleFilePieceBytes(String fileName, long position, byte[] payLoad) {
        throw new UnsupportedOperationException("The config region air gap connector does not support transferring single file piece bytes.");
    }

    protected byte[] getTransferMultiFilePieceBytes(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferConfigSnapshotPieceReq.toTPipeTransferBytes(fileName, position, payLoad);
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBConfigRegionAirGapConnector can't transfer TabletInsertionEvent.");
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBConfigRegionAirGapConnector can't transfer TsFileInsertionEvent.");
    }

    public void transfer(Event event) throws Exception {
        int socketIndex = this.nextSocketIndex();
        IoTDBAirGapConnector.AirGapSocket socket = (IoTDBAirGapConnector.AirGapSocket)this.sockets.get(socketIndex);
        try {
            if (event instanceof PipeConfigRegionWritePlanEvent) {
                this.doTransferWrapper(socket, (PipeConfigRegionWritePlanEvent)event);
            } else if (event instanceof PipeConfigRegionSnapshotEvent) {
                this.doTransferWrapper(socket, (PipeConfigRegionSnapshotEvent)event);
            } else if (!(event instanceof PipeHeartbeatEvent)) {
                LOGGER.warn("IoTDBConfigRegionAirGapConnector does not support transferring generic event: {}.", (Object)event);
            }
        }
        catch (IOException e) {
            this.isSocketAlive.set(socketIndex, false);
            throw new PipeConnectionException(String.format("Network error when transfer event %s, because %s.", ((EnrichedEvent)event).coreReportMessage(), e.getMessage()), (Throwable)e);
        }
    }

    private void doTransferWrapper(IoTDBAirGapConnector.AirGapSocket socket, PipeConfigRegionWritePlanEvent pipeConfigRegionWritePlanEvent) throws PipeException, IOException {
        if (!pipeConfigRegionWritePlanEvent.increaseReferenceCount(IoTDBConfigRegionAirGapConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(socket, pipeConfigRegionWritePlanEvent);
        }
        finally {
            pipeConfigRegionWritePlanEvent.decreaseReferenceCount(IoTDBConfigRegionAirGapConnector.class.getName(), false);
        }
    }

    private void doTransfer(IoTDBAirGapConnector.AirGapSocket socket, PipeConfigRegionWritePlanEvent pipeConfigRegionWritePlanEvent) throws PipeException, IOException {
        if (!this.send(pipeConfigRegionWritePlanEvent.getPipeName(), pipeConfigRegionWritePlanEvent.getCreationTime(), socket, PipeTransferConfigPlanReq.toTPipeTransferBytes(pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan()))) {
            String errorMessage = String.format("Transfer config region write plan %s error. Socket: %s.", new Object[]{pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan().getType(), socket});
            this.sendHandshakeReq(socket);
            this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeConfigRegionWritePlanEvent.toString());
        }
    }

    private void doTransferWrapper(IoTDBAirGapConnector.AirGapSocket socket, PipeConfigRegionSnapshotEvent pipeConfigRegionSnapshotEvent) throws PipeException, IOException {
        if (!pipeConfigRegionSnapshotEvent.increaseReferenceCount(IoTDBConfigRegionAirGapConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(socket, pipeConfigRegionSnapshotEvent);
        }
        finally {
            pipeConfigRegionSnapshotEvent.decreaseReferenceCount(IoTDBConfigRegionAirGapConnector.class.getName(), false);
        }
    }

    private void doTransfer(IoTDBAirGapConnector.AirGapSocket socket, PipeConfigRegionSnapshotEvent pipeConfigRegionSnapshotEvent) throws PipeException, IOException {
        String pipeName = pipeConfigRegionSnapshotEvent.getPipeName();
        long creationTime = pipeConfigRegionSnapshotEvent.getCreationTime();
        File snapshot = pipeConfigRegionSnapshotEvent.getSnapshotFile();
        File templateFile = pipeConfigRegionSnapshotEvent.getTemplateFile();
        this.transferFilePieces(pipeName, creationTime, snapshot, socket, true);
        if (Objects.nonNull(templateFile)) {
            this.transferFilePieces(pipeName, creationTime, templateFile, socket, true);
        }
        if (!this.send(pipeName, creationTime, socket, PipeTransferConfigSnapshotSealReq.toTPipeTransferBytes(pipeConfigRegionSnapshotEvent.getPatternString(), snapshot.getName(), snapshot.length(), Objects.nonNull(templateFile) ? templateFile.getName() : null, Objects.nonNull(templateFile) ? templateFile.length() : 0L, pipeConfigRegionSnapshotEvent.getFileType(), pipeConfigRegionSnapshotEvent.toSealTypeString()))) {
            String errorMessage = String.format("Seal config region snapshot %s error. Socket %s.", snapshot, socket);
            this.sendHandshakeReq(socket);
            this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeConfigRegionSnapshotEvent.toString());
        } else {
            LOGGER.info("Successfully transferred config region snapshot {}.", (Object)snapshot);
        }
    }
}

