/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.mlog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.metadata.logfile.MLogReader;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.tag.TagManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeactivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.utils.CommandLineUtils;
import org.apache.iotdb.isession.util.Version;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogLoader {
    private static final Logger logger = LoggerFactory.getLogger(MLogLoader.class);
    private static final String MLOG_LOAD_PREFIX = "MLogLoad";
    private static final String MLOG_FILE_ARGS = "mlog";
    private static final String MLOG_FILE_NAME = "mlog file";
    private static final String TLOG_FILE_ARGS = "tlog";
    private static final String TLOG_FILE_NAME = "tlog file";
    private static final String PORT_ARGS = "p";
    private static final String PORT_NAME = "receiver port";
    private static final String HOST_ARGS = "h";
    private static final String HOST_NAME = "receiver host";
    private static final String USER_ARGS = "u";
    private static final String USER_NAME = "user";
    private static final String PASSWORD_ARGS = "pw";
    private static final String PASSWORD_NAME = "password";
    private static final String HELP_ARGS = "help";
    private Session session;
    private String mLogFile;
    private String tLogFile;
    private String host;
    private int port;
    private String user;
    private String password;
    private TagManager tagManager;
    private static final int BATCH_NUM_THRESHOLD = 1000;
    private static final int BATCH_MEM_THRESHOLD = 0xA00000;
    private int batchNum;
    private long batchMem;
    private List<String> paths;
    private List<TSDataType> dataTypes;
    private List<TSEncoding> encodings;
    private List<CompressionType> compressors;
    private List<String> alias;
    private List<Map<String, String>> props;
    private List<Map<String, String>> tags;
    private List<Map<String, String>> attributes;
    private long successCnt = 0L;
    private long skipCnt = 0L;
    private long failedCnt = 0L;
    private final ScheduledExecutorService scheduledExecutorService;

    private MLogLoader(CommandLine commandLine) throws ParseException {
        String portTmp;
        this.initBuffer();
        this.mLogFile = CommandLineUtils.checkRequiredArg(MLOG_FILE_ARGS, MLOG_FILE_NAME, commandLine);
        this.host = commandLine.getOptionValue(HOST_ARGS);
        if (this.host == null) {
            this.host = "127.0.0.1";
        }
        this.tLogFile = commandLine.getOptionValue(TLOG_FILE_ARGS);
        if (this.tLogFile == null) {
            logger.warn("No specify tlog.txt file to parse, tag and attributes will be ignored.");
        }
        this.port = (portTmp = commandLine.getOptionValue(PORT_ARGS)) == null ? 6667 : Integer.parseInt(portTmp);
        this.user = commandLine.getOptionValue(USER_ARGS);
        if (this.user == null) {
            this.user = "root";
        }
        this.password = commandLine.getOptionValue(PASSWORD_ARGS);
        if (this.password == null) {
            this.password = "root";
        }
        this.session = new Session.Builder().host(this.host).port(this.port).username(this.user).password(this.password).version(Version.V_0_13).build();
        this.scheduledExecutorService = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor("MLogLogger");
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> logger.info("MLog successfully loaded {} entries, failed {} entries, and skipped {} entries", new Object[]{this.successCnt, this.failedCnt, this.skipCnt}), 1L, 5L, TimeUnit.SECONDS);
    }

    public static Options createOptions() {
        Options options = new Options();
        Option opMlog = Option.builder((String)MLOG_FILE_ARGS).required().argName(MLOG_FILE_NAME).hasArg().desc("Need to specify a binary mlog.bin file to parse (required)").build();
        options.addOption(opMlog);
        Option opTlog = Option.builder((String)TLOG_FILE_ARGS).required(false).argName(TLOG_FILE_NAME).hasArg().desc("Could specify a binary tlog.txt file to parse. Tags and attributes will be ignored if not specified (optional)").build();
        options.addOption(opTlog);
        Option opHost = Option.builder((String)HOST_ARGS).required(false).argName(HOST_NAME).hasArg().desc("Could specify a specify the receiver host, default is 127.0.0.1 (optional)").build();
        options.addOption(opHost);
        Option opPort = Option.builder((String)PORT_ARGS).required(false).argName(PORT_NAME).hasArg().desc("Could specify a specify the receiver port, default is 6667 (optional)").build();
        options.addOption(opPort);
        Option opUser = Option.builder((String)USER_ARGS).required(false).argName(USER_NAME).hasArg().desc("Could specify the user name, default is root (optional)").build();
        options.addOption(opUser);
        Option opPw = Option.builder((String)PASSWORD_ARGS).required(false).argName(PASSWORD_NAME).hasArg().desc("Could specify the password, default is root (optional)").build();
        options.addOption(opPw);
        Option opHelp = Option.builder((String)HELP_ARGS).longOpt(HELP_ARGS).hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        Options options = MLogLoader.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            logger.warn("Too few params input, please check the following hint.");
            hf.printHelp(MLOG_LOAD_PREFIX, options, true);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            logger.error("Parse error: {}", (Object)e.getMessage());
            hf.printHelp(MLOG_LOAD_PREFIX, options, true);
            return;
        }
        if (commandLine.hasOption(HELP_ARGS)) {
            hf.printHelp(MLOG_LOAD_PREFIX, options, true);
            return;
        }
        try {
            MLogLoader mLogLoader = new MLogLoader(commandLine);
            mLogLoader.parseFileAndLoad();
        }
        catch (Exception e) {
            logger.error("Encounter an error, because: {} ", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFileAndLoad() throws Exception {
        try (MLogReader mLogReader = new MLogReader(this.mLogFile);){
            this.session.open(false);
            while (mLogReader.hasNext()) {
                PhysicalPlan plan = mLogReader.next();
                try {
                    switch (plan.getOperatorType()) {
                        case CREATE_TIMESERIES: {
                            CreateTimeSeriesPlan createTimeSeriesPlan = (CreateTimeSeriesPlan)plan;
                            if (createTimeSeriesPlan.getTagOffset() != -1L) {
                                if (this.tLogFile == null) {
                                    createTimeSeriesPlan.setTags(Collections.emptyMap());
                                    createTimeSeriesPlan.setAttributes(Collections.emptyMap());
                                } else {
                                    this.fillTagsAndOffset(createTimeSeriesPlan);
                                }
                            }
                            this.addBatchAndCheck(createTimeSeriesPlan);
                            break;
                        }
                        case CREATE_ALIGNED_TIMESERIES: {
                            CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = (CreateAlignedTimeSeriesPlan)plan;
                            this.session.createAlignedTimeseries(createAlignedTimeSeriesPlan.getPrefixPath().getFullPath(), createAlignedTimeSeriesPlan.getMeasurements(), createAlignedTimeSeriesPlan.getDataTypes(), createAlignedTimeSeriesPlan.getEncodings(), createAlignedTimeSeriesPlan.getCompressors(), createAlignedTimeSeriesPlan.getAliasList());
                            ++this.successCnt;
                            break;
                        }
                        case DELETE_TIMESERIES: {
                            this.flushBuffer();
                            this.session.deleteTimeseries(plan.getPaths().stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
                            ++this.successCnt;
                            break;
                        }
                        case SET_STORAGE_GROUP: {
                            this.session.setStorageGroup(((SetStorageGroupPlan)plan).getPath().getFullPath());
                            ++this.successCnt;
                            break;
                        }
                        case DELETE_STORAGE_GROUP: {
                            this.flushBuffer();
                            this.session.deleteStorageGroups(plan.getPaths().stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
                            ++this.successCnt;
                            break;
                        }
                        case TTL: {
                            SetTTLPlan setTTLPlan = (SetTTLPlan)plan;
                            if (setTTLPlan.getDataTTL() == Long.MAX_VALUE) {
                                this.session.executeNonQueryStatement(String.format("unset ttl to %s", setTTLPlan.getStorageGroup()));
                            } else {
                                this.session.executeNonQueryStatement(String.format("set ttl to %s %d", setTTLPlan.getStorageGroup(), setTTLPlan.getDataTTL()));
                            }
                            ++this.successCnt;
                            break;
                        }
                        case CHANGE_ALIAS: {
                            this.flushBuffer();
                            ChangeAliasPlan changeAliasPlan = (ChangeAliasPlan)plan;
                            this.session.executeNonQueryStatement(String.format("ALTER timeseries %s UPSERT ALIAS=%s", changeAliasPlan.getPath(), changeAliasPlan.getAlias()));
                            ++this.successCnt;
                            break;
                        }
                        case CHANGE_TAG_OFFSET: {
                            this.flushBuffer();
                            if (this.tLogFile == null) {
                                ++this.skipCnt;
                                break;
                            }
                            this.session.executeNonQueryStatement(this.genAlterTimeSeriesSQL((ChangeTagOffsetPlan)plan));
                            ++this.successCnt;
                            break;
                        }
                        case CREATE_TEMPLATE: {
                            Template template = new Template((CreateTemplatePlan)plan);
                            ArrayList<String> measurements = new ArrayList<String>();
                            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
                            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
                            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
                            for (IMeasurementSchema measurementSchema : template.getSchemaMap().values()) {
                                measurements.add(measurementSchema.getMeasurementId());
                                dataTypes.add(measurementSchema.getType());
                                encodings.add(measurementSchema.getEncodingType());
                                compressors.add(measurementSchema.getCompressor());
                            }
                            this.session.createSchemaTemplate(template.getName(), measurements, dataTypes, encodings, compressors, template.isDirectAligned());
                            ++this.successCnt;
                            break;
                        }
                        case APPEND_TEMPLATE: {
                            AppendTemplatePlan appendTemplatePlan = (AppendTemplatePlan)plan;
                            if (appendTemplatePlan.isAligned()) {
                                this.session.addAlignedMeasurementsInTemplate(appendTemplatePlan.getName(), appendTemplatePlan.getMeasurements(), appendTemplatePlan.getDataTypes(), appendTemplatePlan.getEncodings(), appendTemplatePlan.getCompressors());
                            } else {
                                this.session.addUnalignedMeasurementsInTemplate(appendTemplatePlan.getName(), appendTemplatePlan.getMeasurements(), appendTemplatePlan.getDataTypes(), appendTemplatePlan.getEncodings(), appendTemplatePlan.getCompressors());
                            }
                            ++this.successCnt;
                            break;
                        }
                        case PRUNE_TEMPLATE: {
                            PruneTemplatePlan pruneTemplatePlan = (PruneTemplatePlan)plan;
                            this.session.deleteNodeInTemplate(pruneTemplatePlan.getName(), pruneTemplatePlan.getPrunedMeasurements().get(0));
                            ++this.successCnt;
                            break;
                        }
                        case SET_TEMPLATE: {
                            this.flushBuffer();
                            SetTemplatePlan setTemplatePlan = (SetTemplatePlan)plan;
                            this.session.setSchemaTemplate(setTemplatePlan.getTemplateName(), setTemplatePlan.getPrefixPath());
                            ++this.successCnt;
                            break;
                        }
                        case UNSET_TEMPLATE: {
                            UnsetTemplatePlan unsetTemplatePlan = (UnsetTemplatePlan)plan;
                            this.session.unsetSchemaTemplate(unsetTemplatePlan.getPrefixPath(), unsetTemplatePlan.getTemplateName());
                            ++this.successCnt;
                            break;
                        }
                        case DROP_TEMPLATE: {
                            this.session.dropSchemaTemplate(((DropTemplatePlan)plan).getName());
                            ++this.successCnt;
                            break;
                        }
                        case ACTIVATE_TEMPLATE: {
                            this.session.createTimeseriesOfTemplateOnPath(((ActivateTemplatePlan)plan).getPrefixPath().getFullPath());
                            ++this.successCnt;
                            break;
                        }
                        case DEACTIVATE_TEMPLATE: {
                            DeactivateTemplatePlan deactivateTemplatePlan = (DeactivateTemplatePlan)plan;
                            this.session.deactivateTemplateOn(deactivateTemplatePlan.getTemplateName(), deactivateTemplatePlan.getPrefixPath().getFullPath());
                            ++this.successCnt;
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    ++this.failedCnt;
                    logger.error("Fail to load plan {} because {}", (Object)plan, (Object)e.getMessage());
                }
            }
            this.flushBuffer();
        }
        catch (Throwable throwable) {
            this.scheduledExecutorService.shutdown();
            logger.info("MLog loading complete.{} entries loaded successfully, {} entries failed, and {} entries skipped.", new Object[]{this.successCnt, this.failedCnt, this.skipCnt});
            if (this.tagManager != null) {
                this.tagManager.clear();
            }
            this.session.close();
            throw throwable;
        }
        this.scheduledExecutorService.shutdown();
        logger.info("MLog loading complete.{} entries loaded successfully, {} entries failed, and {} entries skipped.", new Object[]{this.successCnt, this.failedCnt, this.skipCnt});
        if (this.tagManager != null) {
            this.tagManager.clear();
        }
        this.session.close();
    }

    private void fillTagsAndOffset(CreateTimeSeriesPlan createTimeSeriesPlan) throws IOException {
        if (this.tagManager == null) {
            this.tagManager = new TagManager();
            File file = new File(this.tLogFile);
            this.tagManager.init(file.getParent(), file.getName());
        }
        Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = this.tagManager.readTagFile(createTimeSeriesPlan.getTagOffset());
        createTimeSeriesPlan.setTags((Map)tagAndAttributePair.left);
        createTimeSeriesPlan.setAttributes((Map)tagAndAttributePair.right);
    }

    private String genAlterTimeSeriesSQL(ChangeTagOffsetPlan changeTagOffsetPlan) throws IOException {
        if (this.tagManager == null) {
            this.tagManager = new TagManager();
            File file = new File(this.tLogFile);
            this.tagManager.init(file.getParent(), file.getName());
        }
        Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = this.tagManager.readTagFile(changeTagOffsetPlan.getOffset());
        StringBuilder stringBuilder = new StringBuilder(String.format("ALTER timeseries %s UPSERT", changeTagOffsetPlan.getPath()));
        if (((Map)tagAndAttributePair.left).size() > 0) {
            stringBuilder.append(" TAGS(");
            stringBuilder.append(StringUtils.join((Object[])((Map)tagAndAttributePair.left).entrySet().stream().map(i -> (String)i.getKey() + "=" + (String)i.getValue()).toArray(), (String)", "));
            stringBuilder.append(")");
        }
        if (((Map)tagAndAttributePair.right).size() > 0) {
            stringBuilder.append(" ATTRIBUTES(");
            stringBuilder.append(StringUtils.join((Object[])((Map)tagAndAttributePair.right).entrySet().stream().map(i -> (String)i.getKey() + "=" + (String)i.getValue()).toArray(), (String)", "));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private void initBuffer() {
        this.paths = new ArrayList<String>();
        this.dataTypes = new ArrayList<TSDataType>();
        this.encodings = new ArrayList<TSEncoding>();
        this.compressors = new ArrayList<CompressionType>();
        this.alias = new ArrayList<String>();
        this.props = new ArrayList<Map<String, String>>();
        this.tags = new ArrayList<Map<String, String>>();
        this.attributes = new ArrayList<Map<String, String>>();
        this.batchNum = 0;
        this.batchMem = RamUsageEstimator.sizeOf(this.paths) + RamUsageEstimator.sizeOf(this.dataTypes) + RamUsageEstimator.sizeOf(this.encodings) + RamUsageEstimator.sizeOf(this.compressors) + RamUsageEstimator.sizeOf(this.alias) + RamUsageEstimator.sizeOf(this.props) + RamUsageEstimator.sizeOf(this.tags) + RamUsageEstimator.sizeOf(this.attributes);
    }

    private void addBatchAndCheck(CreateTimeSeriesPlan plan) throws IoTDBConnectionException, StatementExecutionException {
        this.paths.add(plan.getPath().getFullPath());
        this.dataTypes.add(plan.getDataType());
        this.encodings.add(plan.getEncoding());
        this.compressors.add(plan.getCompressor());
        this.props.add(plan.getProps() == null ? Collections.emptyMap() : plan.getProps());
        this.tags.add(plan.getTags() == null ? Collections.emptyMap() : plan.getTags());
        this.attributes.add(plan.getAttributes() == null ? Collections.emptyMap() : plan.getAttributes());
        this.alias.add(plan.getAlias() == null ? "" : plan.getAlias());
        ++this.batchNum;
        this.batchMem += RamUsageEstimator.sizeOf((Object)plan.getPath().getFullPath()) + RamUsageEstimator.sizeOf((Object)plan.getDataType()) + RamUsageEstimator.sizeOf((Object)plan.getEncoding()) + RamUsageEstimator.sizeOf((Object)plan.getCompressor()) + RamUsageEstimator.sizeOf(plan.getProps() == null ? Collections.emptyMap() : plan.getProps()) + RamUsageEstimator.sizeOf(plan.getTags() == null ? Collections.emptyMap() : plan.getTags()) + RamUsageEstimator.sizeOf(plan.getAttributes() == null ? Collections.emptyMap() : plan.getAttributes()) + RamUsageEstimator.sizeOf((Object)(plan.getAlias() == null ? "" : plan.getAlias()));
        if (this.batchNum >= 1000 || this.batchMem >= 0xA00000L) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IoTDBConnectionException, StatementExecutionException {
        if (this.batchNum > 0) {
            logger.info("Flush buffer and CreateMultiTimeseries.");
            this.session.createMultiTimeseries(this.paths, this.dataTypes, this.encodings, this.compressors, this.props, this.tags, this.attributes, this.alias);
            this.successCnt += (long)this.batchNum;
        }
        this.initBuffer();
    }
}

