/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class DeleteDataOperator
extends Operator {
    private final List<PartialPath> paths;
    private long startTime;
    private long endTime;

    public DeleteDataOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.DELETE;
        this.paths = new ArrayList<PartialPath>();
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    public void addPath(PartialPath path) {
        this.paths.add(path);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long time) {
        this.endTime = time;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        List<PartialPath> originPath = this.getPaths();
        if (this.isPrefixMatchPath()) {
            LinkedList<PartialPath> addedPath = new LinkedList<PartialPath>();
            for (PartialPath path : originPath) {
                addedPath.add(path.concatNode("**"));
            }
            originPath.addAll(addedPath);
        }
        return new DeletePlan(this.getStartTime(), this.getEndTime(), originPath);
    }
}

