/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite.selector;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.IMergePathSelector;
import org.apache.iotdb.db.metadata.path.PartialPath;

public class NaivePathSelector
implements IMergePathSelector {
    private List<PartialPath> paths;
    private int idx;
    private int maxSeriesNum;

    public NaivePathSelector(List<PartialPath> paths, int maxSeriesNum) {
        this.paths = paths;
        this.maxSeriesNum = maxSeriesNum;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.paths.size();
    }

    @Override
    public List<PartialPath> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<PartialPath> ret = this.idx + this.maxSeriesNum <= this.paths.size() ? this.paths.subList(this.idx, this.idx + this.maxSeriesNum) : this.paths.subList(this.idx, this.paths.size());
        this.idx += this.maxSeriesNum;
        return ret;
    }
}

