/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import java.nio.ByteBuffer;
import org.apache.iotdb.cluster.client.sync.SyncMetaClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.exception.AddSelfException;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.exception.LogExecutionException;
import org.apache.iotdb.cluster.exception.PartitionTableUnavailableException;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.apache.iotdb.cluster.rpc.thrift.AddNodeResponse;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.CheckStatusResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.StartUpStatus;
import org.apache.iotdb.cluster.rpc.thrift.TNodeStatus;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.service.BaseSyncService;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSyncService
extends BaseSyncService
implements TSMetaService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(MetaSyncService.class);
    private MetaGroupMember metaGroupMember;
    private static final String ERROR_MSG_META_NOT_READY = "The metadata not is not ready.";

    public MetaSyncService(MetaGroupMember metaGroupMember) {
        super(metaGroupMember);
        this.metaGroupMember = metaGroupMember;
    }

    @Override
    public long appendEntry(AppendEntryRequest request) throws TException {
        if (!this.metaGroupMember.isReady() && this.metaGroupMember.getPartitionTable() == null) {
            logger.debug("This node is blind to the cluster and cannot accept logs, {}", (Object)request);
            return -4L;
        }
        return super.appendEntry(request);
    }

    public AddNodeResponse addNode(Node node, StartUpStatus startUpStatus) throws TException {
        AddNodeResponse addNodeResponse;
        if (!this.metaGroupMember.isReady()) {
            logger.debug(ERROR_MSG_META_NOT_READY);
            throw new TException(ERROR_MSG_META_NOT_READY);
        }
        try {
            addNodeResponse = this.metaGroupMember.addNode(node, startUpStatus);
        }
        catch (AddSelfException | CheckConsistencyException | LogExecutionException e) {
            throw new TException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TException((Throwable)e);
        }
        if (addNodeResponse != null) {
            return addNodeResponse;
        }
        if (this.member.getCharacter() == NodeCharacter.FOLLOWER && this.member.getLeader() != null && !ClusterConstant.EMPTY_NODE.equals(this.member.getLeader())) {
            logger.info("Forward the join request of {} to leader {}", (Object)node, (Object)this.member.getLeader());
            addNodeResponse = this.forwardAddNode(node, startUpStatus);
            if (addNodeResponse != null) {
                return addNodeResponse;
            }
        }
        throw new TException((Throwable)new LeaderUnknownException(this.member.getAllNodes()));
    }

    public void sendSnapshot(SendSnapshotRequest request) throws TException {
        try {
            this.metaGroupMember.receiveSnapshot(request);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    public CheckStatusResponse checkStatus(StartUpStatus startUpStatus) {
        return ClusterUtils.checkStatus(startUpStatus, this.metaGroupMember.getStartUpStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddNodeResponse forwardAddNode(Node node, StartUpStatus startUpStatus) {
        SyncMetaClient client = (SyncMetaClient)this.metaGroupMember.getSyncClient(this.metaGroupMember.getLeader());
        if (client != null) {
            try {
                AddNodeResponse addNodeResponse = client.addNode(node, startUpStatus);
                return addNodeResponse;
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                logger.warn("Cannot connect to node {}", (Object)node, (Object)e);
            }
            finally {
                ClientUtils.putBackSyncClient((RaftService.Client)client);
            }
        }
        return null;
    }

    public TNodeStatus queryNodeStatus() {
        return new TNodeStatus();
    }

    public Node checkAlive() {
        return this.metaGroupMember.getThisNode();
    }

    public ByteBuffer collectMigrationStatus() {
        return ClusterUtils.serializeMigrationStatus(this.metaGroupMember.collectMigrationStatus());
    }

    public long removeNode(Node node) throws TException {
        long result;
        if (!this.metaGroupMember.isReady()) {
            logger.debug(ERROR_MSG_META_NOT_READY);
            throw new TException(ERROR_MSG_META_NOT_READY);
        }
        try {
            result = this.metaGroupMember.removeNode(node);
        }
        catch (CheckConsistencyException | LogExecutionException | PartitionTableUnavailableException e) {
            logger.error("Can not remove node {}", (Object)node, (Object)e);
            throw new TException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Can not remove node {}", (Object)node, (Object)e);
            throw new TException((Throwable)e);
        }
        if (result != Long.MIN_VALUE) {
            return result;
        }
        if (this.metaGroupMember.getCharacter() == NodeCharacter.FOLLOWER && this.metaGroupMember.getLeader() != null) {
            logger.info("Forward the node removal request of {} to leader {}", (Object)node, (Object)this.metaGroupMember.getLeader());
            Long rst = this.forwardRemoveNode(node);
            if (rst != null) {
                return rst;
            }
        }
        throw new TException((Throwable)new LeaderUnknownException(this.metaGroupMember.getAllNodes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long forwardRemoveNode(Node node) {
        SyncMetaClient client = (SyncMetaClient)this.metaGroupMember.getSyncClient(this.metaGroupMember.getLeader());
        if (client != null) {
            try {
                Long l = client.removeNode(node);
                return l;
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                logger.warn("Cannot connect to node {}", (Object)node, (Object)e);
            }
            finally {
                ClientUtils.putBackSyncClient((RaftService.Client)client);
            }
        }
        return null;
    }

    public void exile(ByteBuffer removeNodeLogBuffer) {
        logger.info("{}: start to exile.", (Object)this.name);
        removeNodeLogBuffer.get();
        RemoveNodeLog removeNodeLog = new RemoveNodeLog();
        removeNodeLog.deserialize(removeNodeLogBuffer);
        this.metaGroupMember.getPartitionTable().deserialize(removeNodeLog.getPartitionTable());
        this.metaGroupMember.applyRemoveNode(removeNodeLog);
    }

    public void handshake(Node sender) {
        this.metaGroupMember.handleHandshake(sender);
    }
}

