/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.logtypes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.cluster.log.Log;

public class EmptyContentLog
extends Log {
    public EmptyContentLog() {
    }

    public EmptyContentLog(long index, long term) {
        this.setCurrLogIndex(index);
        this.setCurrLogTerm(term);
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeByte((byte)Log.Types.EMPTY_CONTENT.ordinal());
            dataOutputStream.writeLong(this.getCurrLogIndex());
            dataOutputStream.writeLong(this.getCurrLogTerm());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.setCurrLogIndex(buffer.getLong());
        this.setCurrLogTerm(buffer.getLong());
    }

    public String toString() {
        return "term:" + this.getCurrLogTerm() + ",index:" + this.getCurrLogIndex();
    }
}

