/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class HardState {
    private long currentTerm;
    private Node voteFor = null;

    public static HardState deserialize(ByteBuffer buffer) {
        HardState res = new HardState();
        res.setCurrentTerm(ReadWriteIOUtils.readLong((ByteBuffer)buffer));
        byte isNull = buffer.get();
        if (isNull == 1) {
            Node node = new Node();
            NodeSerializeUtils.deserialize(node, buffer);
            res.setVoteFor(node);
        } else {
            res.setVoteFor(null);
        }
        return res;
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeLong(this.currentTerm);
            if (this.voteFor == null) {
                dataOutputStream.writeByte(0);
            } else {
                dataOutputStream.writeByte(1);
                NodeSerializeUtils.serialize(this.voteFor, dataOutputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(outputStream.toByteArray());
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public void setCurrentTerm(long currentTerm) {
        this.currentTerm = currentTerm;
    }

    public Node getVoteFor() {
        return this.voteFor;
    }

    public void setVoteFor(Node voteFor) {
        this.voteFor = voteFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HardState)) {
            return false;
        }
        HardState that = (HardState)o;
        return new EqualsBuilder().append(this.currentTerm, that.currentTerm).append((Object)this.voteFor, (Object)that.voteFor).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.currentTerm).append((Object)this.voteFor).toHashCode();
    }

    public String toString() {
        return "HardState{currentTerm=" + this.currentTerm + ", voteFor=" + this.voteFor + '}';
    }
}

