package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.TilePointCrs;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("tilePoint")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class TilePoint   {
  private @Valid List<BigDecimal> coordinates = new ArrayList<>();
  private @Valid TilePointCrs crs;
  private @Valid String tileMatrix;
  private @Valid BigDecimal scaleDenominator;
  private @Valid BigDecimal cellSize;

  /**
   **/
  public TilePoint coordinates(List<BigDecimal> coordinates) {
    this.coordinates = coordinates;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("coordinates")
  @NotNull
 @Size(min=2,max=2)  public List<BigDecimal> getCoordinates() {
    return coordinates;
  }

  @JsonProperty("coordinates")
  public void setCoordinates(List<BigDecimal> coordinates) {
    this.coordinates = coordinates;
  }

  public TilePoint addCoordinatesItem(BigDecimal coordinatesItem) {
    if (this.coordinates == null) {
      this.coordinates = new ArrayList<>();
    }

    this.coordinates.add(coordinatesItem);
    return this;
  }

  public TilePoint removeCoordinatesItem(BigDecimal coordinatesItem) {
    if (coordinatesItem != null && this.coordinates != null) {
      this.coordinates.remove(coordinatesItem);
    }

    return this;
  }
  /**
   **/
  public TilePoint crs(TilePointCrs crs) {
    this.crs = crs;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("crs")
  public TilePointCrs getCrs() {
    return crs;
  }

  @JsonProperty("crs")
  public void setCrs(TilePointCrs crs) {
    this.crs = crs;
  }

  /**
   * TileMatrix identifier associated with the scaleDenominator
   **/
  public TilePoint tileMatrix(String tileMatrix) {
    this.tileMatrix = tileMatrix;
    return this;
  }

  
  @ApiModelProperty(value = "TileMatrix identifier associated with the scaleDenominator")
  @JsonProperty("tileMatrix")
  public String getTileMatrix() {
    return tileMatrix;
  }

  @JsonProperty("tileMatrix")
  public void setTileMatrix(String tileMatrix) {
    this.tileMatrix = tileMatrix;
  }

  /**
   * Scale denominator of the tile matrix selected
   **/
  public TilePoint scaleDenominator(BigDecimal scaleDenominator) {
    this.scaleDenominator = scaleDenominator;
    return this;
  }

  
  @ApiModelProperty(value = "Scale denominator of the tile matrix selected")
  @JsonProperty("scaleDenominator")
  public BigDecimal getScaleDenominator() {
    return scaleDenominator;
  }

  @JsonProperty("scaleDenominator")
  public void setScaleDenominator(BigDecimal scaleDenominator) {
    this.scaleDenominator = scaleDenominator;
  }

  /**
   * Cell size of the tile matrix selected
   **/
  public TilePoint cellSize(BigDecimal cellSize) {
    this.cellSize = cellSize;
    return this;
  }

  
  @ApiModelProperty(value = "Cell size of the tile matrix selected")
  @JsonProperty("cellSize")
  public BigDecimal getCellSize() {
    return cellSize;
  }

  @JsonProperty("cellSize")
  public void setCellSize(BigDecimal cellSize) {
    this.cellSize = cellSize;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TilePoint tilePoint = (TilePoint) o;
    return Objects.equals(this.coordinates, tilePoint.coordinates) &&
        Objects.equals(this.crs, tilePoint.crs) &&
        Objects.equals(this.tileMatrix, tilePoint.tileMatrix) &&
        Objects.equals(this.scaleDenominator, tilePoint.scaleDenominator) &&
        Objects.equals(this.cellSize, tilePoint.cellSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(coordinates, crs, tileMatrix, scaleDenominator, cellSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TilePoint {\n");
    
    sb.append("    coordinates: ").append(toIndentedString(coordinates)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    tileMatrix: ").append(toIndentedString(tileMatrix)).append("\n");
    sb.append("    scaleDenominator: ").append(toIndentedString(scaleDenominator)).append("\n");
    sb.append("    cellSize: ").append(toIndentedString(cellSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

