package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.Link;
import org.apache.baremaps.ogcapi.model.TileSetCrs;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A minimal tile matrix set element for use within a list of tile matrix sets linking to a full definition.
 **/
@ApiModel(description = "A minimal tile matrix set element for use within a list of tile matrix sets linking to a full definition.")
@JsonTypeName("tileMatrixSet-item")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class TileMatrixSetItem   {
  private @Valid String id;
  private @Valid String title;
  private @Valid URI uri;
  private @Valid TileSetCrs crs;
  private @Valid List<Link> links = new ArrayList<>();

  /**
   * Optional local tile matrix set identifier, e.g. for use as unspecified &#x60;{tileSetId}&#x60; parameter. Implementation of &#39;identifier&#39;
   **/
  public TileMatrixSetItem id(String id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(value = "Optional local tile matrix set identifier, e.g. for use as unspecified `{tileSetId}` parameter. Implementation of 'identifier'")
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  /**
   * Title of this tile matrix set, normally used for display to a human
   **/
  public TileMatrixSetItem title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "Title of this tile matrix set, normally used for display to a human")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Reference to an official source for this tileMatrixSet
   **/
  public TileMatrixSetItem uri(URI uri) {
    this.uri = uri;
    return this;
  }

  
  @ApiModelProperty(value = "Reference to an official source for this tileMatrixSet")
  @JsonProperty("uri")
  public URI getUri() {
    return uri;
  }

  @JsonProperty("uri")
  public void setUri(URI uri) {
    this.uri = uri;
  }

  /**
   **/
  public TileMatrixSetItem crs(TileSetCrs crs) {
    this.crs = crs;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("crs")
  public TileSetCrs getCrs() {
    return crs;
  }

  @JsonProperty("crs")
  public void setCrs(TileSetCrs crs) {
    this.crs = crs;
  }

  /**
   * Links to related resources. A &#39;self&#39; link to the tile matrix set definition is required.
   **/
  public TileMatrixSetItem links(List<Link> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Links to related resources. A 'self' link to the tile matrix set definition is required.")
  @JsonProperty("links")
  @NotNull
  public List<Link> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link> links) {
    this.links = links;
  }

  public TileMatrixSetItem addLinksItem(Link linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public TileMatrixSetItem removeLinksItem(Link linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TileMatrixSetItem tileMatrixSetItem = (TileMatrixSetItem) o;
    return Objects.equals(this.id, tileMatrixSetItem.id) &&
        Objects.equals(this.title, tileMatrixSetItem.title) &&
        Objects.equals(this.uri, tileMatrixSetItem.uri) &&
        Objects.equals(this.crs, tileMatrixSetItem.crs) &&
        Objects.equals(this.links, tileMatrixSetItem.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, title, uri, crs, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TileMatrixSetItem {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

