/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.disaster;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryRequestsSerialization;
import org.apache.ignite3.internal.table.distributed.disaster.GroupUpdateRequest;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

class GroupUpdateRequestSerializer
extends VersionedSerializer<GroupUpdateRequest> {
    static final GroupUpdateRequestSerializer INSTANCE = new GroupUpdateRequestSerializer();

    GroupUpdateRequestSerializer() {
    }

    @Override
    protected byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(GroupUpdateRequest request, IgniteDataOutput out) throws IOException {
        out.writeUuid(request.operationId());
        out.writeVarInt(request.catalogVersion());
        out.writeVarInt(request.zoneId());
        DisasterRecoveryRequestsSerialization.writeVarIntMap(request.partitionIds(), out);
        out.writeBoolean(request.manualUpdate());
        out.writeBoolean(request.colocationEnabled());
    }

    @Override
    protected GroupUpdateRequest readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        UUID operationId = in.readUuid();
        int catalogVersion = in.readVarIntAsInt();
        int zoneId = in.readVarIntAsInt();
        Map<Integer, Set<Integer>> partitionIds = DisasterRecoveryRequestsSerialization.readVarIntMap(in);
        boolean manualUpdate = in.readBoolean();
        boolean usesZonePartitionIds = protoVer >= 2 ? in.readBoolean() : false;
        return GroupUpdateRequest.create(operationId, catalogVersion, zoneId, partitionIds, manualUpdate, usesZonePartitionIds);
    }
}

