/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.meta;

import java.util.UUID;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaKey;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class IndexMeta
extends IndexMetaKey {
    private final IndexType indexType;
    @IgniteToStringExclude
    private final long metaPageId;
    @Nullable
    private final UUID nextRowIdUuidToBuild;

    public IndexMeta(int id, IndexType indexType, long metaPageId, @Nullable UUID nextRowIdUuidToBuild) {
        super(id);
        this.indexType = indexType;
        this.metaPageId = metaPageId;
        this.nextRowIdUuidToBuild = nextRowIdUuidToBuild;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public long metaPageId() {
        return this.metaPageId;
    }

    @Nullable
    public UUID nextRowIdUuidToBuild() {
        return this.nextRowIdUuidToBuild;
    }

    @Override
    public String toString() {
        return S.toString(IndexMeta.class, this, "indexId=", (Object)this.indexId(), "metaPageId", (Object)StringUtils.hexLong(this.metaPageId));
    }

    public static enum IndexType {
        HASH(0),
        SORTED(1);

        private final byte serializationValue;

        private IndexType(byte serializationValue) {
            this.serializationValue = serializationValue;
        }

        public byte serialize() {
            return this.serializationValue;
        }

        public static IndexType deserialize(byte serializationValue) {
            if (IndexType.HASH.serializationValue == serializationValue) {
                return HASH;
            }
            if (IndexType.SORTED.serializationValue == serializationValue) {
                return SORTED;
            }
            throw new AssertionError((Object)("Unknown serialization value: " + serializationValue));
        }
    }
}

