/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogStorageProfilesDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class CatalogZoneDescriptor
extends CatalogObjectDescriptor
implements MarshallableEntry {
    private final int partitions;
    private final int replicas;
    private final int quorumSize;
    private final int dataNodesAutoAdjust;
    private final int dataNodesAutoAdjustScaleUp;
    private final int dataNodesAutoAdjustScaleDown;
    private final String filter;
    private final CatalogStorageProfilesDescriptor storageProfiles;
    private final ConsistencyMode consistencyMode;

    public static boolean updateRequiresAssignmentsRecalculation(CatalogZoneDescriptor oldDescriptor, CatalogZoneDescriptor newDescriptor) {
        if (oldDescriptor.updateTimestamp().equals(newDescriptor.updateTimestamp())) {
            return false;
        }
        return oldDescriptor.partitions != newDescriptor.partitions || oldDescriptor.replicas != newDescriptor.replicas || oldDescriptor.quorumSize != newDescriptor.quorumSize || !oldDescriptor.filter.equals(newDescriptor.filter) || !oldDescriptor.storageProfiles.profiles().equals(newDescriptor.storageProfiles.profiles()) || oldDescriptor.consistencyMode != newDescriptor.consistencyMode;
    }

    @Deprecated
    public CatalogZoneDescriptor(int id, String name, int partitions, int replicas, int quorumSize, int dataNodesAutoAdjust, int dataNodesAutoAdjustScaleUp, int dataNodesAutoAdjustScaleDown, String filter, CatalogStorageProfilesDescriptor storageProfiles, ConsistencyMode consistencyMode) {
        this(id, name, partitions, replicas, quorumSize, dataNodesAutoAdjust, dataNodesAutoAdjustScaleUp, dataNodesAutoAdjustScaleDown, filter, storageProfiles, CatalogManager.INITIAL_TIMESTAMP, consistencyMode);
    }

    public CatalogZoneDescriptor(int id, String name, int partitions, int replicas, int quorumSize, int dataNodesAutoAdjustScaleUp, int dataNodesAutoAdjustScaleDown, String filter, CatalogStorageProfilesDescriptor storageProfiles, ConsistencyMode consistencyMode) {
        this(id, name, partitions, replicas, quorumSize, 0, dataNodesAutoAdjustScaleUp, dataNodesAutoAdjustScaleDown, filter, storageProfiles, CatalogManager.INITIAL_TIMESTAMP, consistencyMode);
    }

    @Deprecated
    CatalogZoneDescriptor(int id, String name, int partitions, int replicas, int quorumSize, int dataNodesAutoAdjust, int dataNodesAutoAdjustScaleUp, int dataNodesAutoAdjustScaleDown, String filter, CatalogStorageProfilesDescriptor storageProfiles, HybridTimestamp timestamp, ConsistencyMode consistencyMode) {
        super(id, CatalogObjectDescriptor.Type.ZONE, name, timestamp);
        this.partitions = partitions;
        this.replicas = replicas;
        this.quorumSize = quorumSize;
        this.dataNodesAutoAdjust = dataNodesAutoAdjust;
        this.dataNodesAutoAdjustScaleUp = dataNodesAutoAdjustScaleUp;
        this.dataNodesAutoAdjustScaleDown = dataNodesAutoAdjustScaleDown;
        this.filter = filter;
        this.storageProfiles = storageProfiles;
        this.consistencyMode = consistencyMode;
    }

    CatalogZoneDescriptor(int id, String name, int partitions, int replicas, int quorumSize, int dataNodesAutoAdjustScaleUp, int dataNodesAutoAdjustScaleDown, String filter, CatalogStorageProfilesDescriptor storageProfiles, HybridTimestamp timestamp, ConsistencyMode consistencyMode) {
        super(id, CatalogObjectDescriptor.Type.ZONE, name, timestamp);
        this.partitions = partitions;
        this.replicas = replicas;
        this.quorumSize = quorumSize;
        this.dataNodesAutoAdjust = 0;
        this.dataNodesAutoAdjustScaleUp = dataNodesAutoAdjustScaleUp;
        this.dataNodesAutoAdjustScaleDown = dataNodesAutoAdjustScaleDown;
        this.filter = filter;
        this.storageProfiles = storageProfiles;
        this.consistencyMode = consistencyMode;
    }

    public int partitions() {
        return this.partitions;
    }

    public int replicas() {
        return this.replicas;
    }

    public int quorumSize() {
        return this.quorumSize;
    }

    public int consensusGroupSize() {
        return Math.min(this.quorumSize * 2 - 1, this.replicas);
    }

    @Deprecated
    public int dataNodesAutoAdjust() {
        return this.dataNodesAutoAdjust;
    }

    public int dataNodesAutoAdjustScaleUp() {
        return this.dataNodesAutoAdjustScaleUp;
    }

    public int dataNodesAutoAdjustScaleDown() {
        return this.dataNodesAutoAdjustScaleDown;
    }

    public String filter() {
        return this.filter;
    }

    public ConsistencyMode consistencyMode() {
        return this.consistencyMode;
    }

    public CatalogStorageProfilesDescriptor storageProfiles() {
        return this.storageProfiles;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_ZONE.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogZoneDescriptor.class, this, super.toString());
    }
}

