/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.instruction;

import com.facebook.presto.bytecode.ArrayOpCode;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.instruction.InstructionNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class TypeInstruction
implements InstructionNode {
    private final OpCode opCode;
    private final ParameterizedType type;

    public static InstructionNode newObject(Class<?> type) {
        return new TypeInstruction(OpCode.NEW, ParameterizedType.type(type));
    }

    public static InstructionNode newObject(ParameterizedType type) {
        return new TypeInstruction(OpCode.NEW, type);
    }

    public static InstructionNode newPrimitiveArray(ParameterizedType type) {
        return new TypeInstruction(OpCode.NEWARRAY, type);
    }

    public static InstructionNode newObjectArray(Class<?> type) {
        return new TypeInstruction(OpCode.ANEWARRAY, ParameterizedType.type(type));
    }

    public static InstructionNode newObjectArray(ParameterizedType type) {
        return new TypeInstruction(OpCode.ANEWARRAY, type);
    }

    public static InstructionNode instanceOf(Class<?> type) {
        return new TypeInstruction(OpCode.INSTANCEOF, ParameterizedType.type(type));
    }

    public static InstructionNode instanceOf(ParameterizedType type) {
        return new TypeInstruction(OpCode.INSTANCEOF, type);
    }

    public static InstructionNode cast(Class<?> type) {
        return new TypeInstruction(OpCode.CHECKCAST, ParameterizedType.type(type));
    }

    public static InstructionNode cast(ParameterizedType type) {
        return new TypeInstruction(OpCode.CHECKCAST, type);
    }

    public TypeInstruction(OpCode opCode, ParameterizedType type) {
        this.opCode = opCode;
        this.type = type;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        if (this.opCode == OpCode.NEWARRAY) {
            BytecodeUtils.checkState(this.type.isPrimitive(), "need primitive type for NEWARRAY");
            visitor.visitIntInsn(this.opCode.getOpCode(), TypeInstruction.getPrimitiveArrayType(this.type));
        } else {
            visitor.visitTypeInsn(this.opCode.getOpCode(), this.type.getClassName());
        }
    }

    private static int getPrimitiveArrayType(ParameterizedType type) {
        return ArrayOpCode.getArrayOpCode(type).getAtype();
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of();
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitInstruction(parent, this);
    }

    public String toString() {
        return this.opCode + " " + this.type;
    }
}

