/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Date;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.systemview.walker.Order;

public class NodeMetricsView {
    private final ClusterNode node;
    private final ClusterMetrics metrics;

    public NodeMetricsView(ClusterNode node) {
        this.node = node;
        this.metrics = node.metrics();
    }

    @Order
    public UUID nodeId() {
        return this.node.id();
    }

    @Order(value=1)
    public Date lastUpdateTime() {
        return new Date(this.metrics.getLastUpdateTime());
    }

    @Order(value=2)
    public int maxActiveJobs() {
        return this.metrics.getMaximumActiveJobs();
    }

    @Order(value=3)
    public int curActiveJobs() {
        return this.metrics.getCurrentActiveJobs();
    }

    @Order(value=4)
    public float avgActiveJobs() {
        return this.metrics.getAverageActiveJobs();
    }

    @Order(value=5)
    public int maxWaitingJobs() {
        return this.metrics.getMaximumWaitingJobs();
    }

    @Order(value=6)
    public int curWaitingJobs() {
        return this.metrics.getCurrentWaitingJobs();
    }

    @Order(value=7)
    public float avgWaitingJobs() {
        return this.metrics.getAverageWaitingJobs();
    }

    @Order(value=8)
    public int maxRejectedJobs() {
        return this.metrics.getMaximumRejectedJobs();
    }

    @Order(value=9)
    public int curRejectedJobs() {
        return this.metrics.getCurrentRejectedJobs();
    }

    @Order(value=10)
    public float avgRejectedJobs() {
        return this.metrics.getAverageRejectedJobs();
    }

    @Order(value=11)
    public int totalRejectedJobs() {
        return this.metrics.getTotalRejectedJobs();
    }

    @Order(value=12)
    public int maxCanceledJobs() {
        return this.metrics.getMaximumCancelledJobs();
    }

    @Order(value=13)
    public int curCanceledJobs() {
        return this.metrics.getCurrentCancelledJobs();
    }

    @Order(value=14)
    public float avgCanceledJobs() {
        return this.metrics.getAverageCancelledJobs();
    }

    @Order(value=15)
    public int totalCanceledJobs() {
        return this.metrics.getTotalCancelledJobs();
    }

    @Order(value=16)
    public long maxJobsWaitTime() {
        return this.metrics.getMaximumJobWaitTime();
    }

    @Order(value=17)
    public long curJobsWaitTime() {
        return this.metrics.getCurrentJobWaitTime();
    }

    @Order(value=18)
    public long avgJobsWaitTime() {
        return (long)this.metrics.getAverageJobWaitTime();
    }

    @Order(value=19)
    public long maxJobsExecuteTime() {
        return this.metrics.getMaximumJobExecuteTime();
    }

    @Order(value=20)
    public long curJobsExecuteTime() {
        return this.metrics.getCurrentJobExecuteTime();
    }

    @Order(value=21)
    public long avgJobsExecuteTime() {
        return (long)this.metrics.getAverageJobExecuteTime();
    }

    @Order(value=22)
    public long totalJobsExecuteTime() {
        return this.metrics.getTotalJobsExecutionTime();
    }

    @Order(value=23)
    public int totalExecutedJobs() {
        return this.metrics.getTotalExecutedJobs();
    }

    @Order(value=24)
    public int totalExecutedTasks() {
        return this.metrics.getTotalExecutedTasks();
    }

    @Order(value=25)
    public long totalBusyTime() {
        return this.metrics.getTotalBusyTime();
    }

    @Order(value=26)
    public long totalIdleTime() {
        return this.metrics.getTotalIdleTime();
    }

    @Order(value=27)
    public long curIdleTime() {
        return this.metrics.getCurrentIdleTime();
    }

    @Order(value=28)
    public float busyTimePercentage() {
        return this.metrics.getBusyTimePercentage();
    }

    @Order(value=29)
    public float idleTimePercentage() {
        return this.metrics.getIdleTimePercentage();
    }

    @Order(value=30)
    public int totalCpu() {
        return this.metrics.getTotalCpus();
    }

    @Order(value=31)
    public double curCpuLoad() {
        return this.metrics.getCurrentCpuLoad();
    }

    @Order(value=32)
    public double avgCpuLoad() {
        return this.metrics.getAverageCpuLoad();
    }

    @Order(value=33)
    public double curGcCpuLoad() {
        return this.metrics.getCurrentGcCpuLoad();
    }

    @Order(value=34)
    public long heapMemoryInit() {
        return this.metrics.getHeapMemoryInitialized();
    }

    @Order(value=35)
    public long heapMemoryUsed() {
        return this.metrics.getHeapMemoryUsed();
    }

    @Order(value=36)
    public long heapMemoryCommited() {
        return this.metrics.getHeapMemoryCommitted();
    }

    @Order(value=37)
    public long heapMemoryMax() {
        return this.metrics.getHeapMemoryMaximum();
    }

    @Order(value=38)
    public long heapMemoryTotal() {
        return this.metrics.getHeapMemoryTotal();
    }

    @Order(value=39)
    public long nonheapMemoryInit() {
        return this.metrics.getNonHeapMemoryInitialized();
    }

    @Order(value=40)
    public long nonheapMemoryUsed() {
        return this.metrics.getNonHeapMemoryUsed();
    }

    @Order(value=41)
    public long nonheapMemoryCommited() {
        return this.metrics.getNonHeapMemoryCommitted();
    }

    @Order(value=42)
    public long nonheapMemoryMax() {
        return this.metrics.getNonHeapMemoryMaximum();
    }

    @Order(value=43)
    public long nonheapMemoryTotal() {
        return this.metrics.getNonHeapMemoryTotal();
    }

    @Order(value=44)
    public long uptime() {
        return this.metrics.getUpTime();
    }

    @Order(value=45)
    public Date jvmStartTime() {
        return new Date(this.metrics.getStartTime());
    }

    @Order(value=46)
    public Date nodeStartTime() {
        return new Date(this.metrics.getNodeStartTime());
    }

    @Order(value=47)
    public long lastDataVersion() {
        return this.metrics.getLastDataVersion();
    }

    @Order(value=48)
    public int curThreadCount() {
        return this.metrics.getCurrentThreadCount();
    }

    @Order(value=49)
    public int maxThreadCount() {
        return this.metrics.getMaximumThreadCount();
    }

    @Order(value=50)
    public long totalThreadCount() {
        return this.metrics.getTotalStartedThreadCount();
    }

    @Order(value=51)
    public int curDaemonThreadCount() {
        return this.metrics.getCurrentDaemonThreadCount();
    }

    @Order(value=52)
    public int sentMessagesCount() {
        return this.metrics.getSentMessagesCount();
    }

    @Order(value=53)
    public long sentBytesCount() {
        return this.metrics.getSentBytesCount();
    }

    @Order(value=54)
    public int receivedMessagesCount() {
        return this.metrics.getReceivedMessagesCount();
    }

    @Order(value=55)
    public long receivedBytesCount() {
        return this.metrics.getReceivedBytesCount();
    }

    @Order(value=56)
    public int outboundMessagesQueue() {
        return this.metrics.getOutboundMessagesQueueSize();
    }
}

