/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partitiondistribution;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;

public class PendingAssignmentsCalculator {
    private Assignments stable;
    private Assignments target;

    private PendingAssignmentsCalculator() {
    }

    public static PendingAssignmentsCalculator pendingAssignmentsCalculator() {
        return new PendingAssignmentsCalculator();
    }

    public PendingAssignmentsCalculator stable(Assignments stable) {
        this.stable = stable;
        return this;
    }

    public PendingAssignmentsCalculator target(Assignments target) {
        this.target = target;
        return this;
    }

    public AssignmentsQueue toQueue() {
        AssignmentsQueue queue;
        assert (this.stable != null);
        assert (this.target != null);
        if (this.target.force() || this.target.fromReset()) {
            return new AssignmentsQueue(this.target);
        }
        int size = this.target.nodes().size();
        HashSet base = IgniteUtils.newHashSet((int)size);
        HashSet promoted = IgniteUtils.newHashSet((int)size);
        HashSet demoted = IgniteUtils.newHashSet((int)size);
        HashSet demotedPeers = IgniteUtils.newHashSet((int)size);
        for (Assignment t : this.target.nodes()) {
            boolean found = false;
            for (Assignment s : this.stable.nodes()) {
                if (s.equals(t)) {
                    found = true;
                    base.add(t);
                    continue;
                }
                if (!t.consistentId().equals(s.consistentId())) continue;
                found = true;
                if (!s.isPeer() && t.isPeer()) {
                    promoted.add(t);
                }
                if (!s.isPeer() || t.isPeer()) continue;
                demoted.add(t);
                demotedPeers.add(s);
            }
            if (found) continue;
            base.add(t);
        }
        if (promoted.isEmpty() && demoted.isEmpty()) {
            queue = new AssignmentsQueue(Assignments.of(base, this.target.timestamp()));
        } else if (promoted.isEmpty() || demoted.isEmpty()) {
            Set withPromotedOrDemoted = CollectionUtils.union((Set)base, (Set)(promoted.isEmpty() ? demoted : promoted));
            queue = new AssignmentsQueue(Assignments.of(base, this.target.timestamp()), Assignments.of(withPromotedOrDemoted, this.target.timestamp()));
        } else {
            Set withOldPeers = CollectionUtils.union((Set)base, (Set)demotedPeers);
            Set withPromoted = CollectionUtils.union((Set)base, (Set)promoted);
            Set withDemotedPeers = CollectionUtils.union((Set)withPromoted, (Set)demoted);
            queue = new AssignmentsQueue(Assignments.of(withOldPeers, this.target.timestamp()), Assignments.of(withPromoted, this.target.timestamp()), Assignments.of(withDemotedPeers, this.target.timestamp()));
        }
        assert (Objects.equals(queue.peekLast().nodes(), this.target.nodes())) : "Target assignments should be equal to the last element in the queue";
        return queue;
    }
}

