/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table.mapper;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.util.IgniteNameUtils;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.mapper.OneColumnMapperImpl;
import org.apache.ignite.table.mapper.PojoMapperImpl;
import org.apache.ignite.table.mapper.TypeConverter;
import org.jetbrains.annotations.NotNull;

public final class MapperBuilder<T> {
    private Class<T> targetType;
    private Map<String, String> columnToFields;
    private Map<String, TypeConverter<?, ?>> columnConverters = new HashMap();
    private final String mappedToColumn;
    private boolean automapFlag = false;
    private boolean isStale;

    MapperBuilder(@NotNull Class<T> targetType) {
        this.targetType = this.ensureValidPojo(targetType);
        this.mappedToColumn = null;
        this.columnToFields = new HashMap<String, String>(targetType.getDeclaredFields().length);
    }

    MapperBuilder(@NotNull Class<T> targetType, String mappedColumn) {
        this.targetType = Mapper.ensureNativelySupported(targetType);
        this.mappedToColumn = mappedColumn;
        this.columnToFields = null;
    }

    public <O> Class<O> ensureValidPojo(@NotNull Class<O> type) {
        if (Mapper.nativelySupported(type)) {
            throw new IllegalArgumentException("Unsupported class. Can't map fields of natively supported type: " + type.getName());
        }
        if (type.isAnonymousClass() || type.isLocalClass() || type.isSynthetic() || type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
            throw new IllegalArgumentException("Unsupported class. Only top-level or nested static classes are supported: " + type.getName());
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("Unsupported class. Abstract classes are not supported: " + type.getName());
        }
        if (type.isEnum()) {
            throw new IllegalArgumentException("Unsupported class. Enum is not supported, please use a converter: " + type.getName());
        }
        if (type.isArray()) {
            throw new IllegalArgumentException("Unsupported class. Arrays are not supported: " + type.getName());
        }
        if (type.isAnnotation() || type.isInterface()) {
            throw new IllegalArgumentException("Unsupported class. Interfaces are not supported: " + type.getName());
        }
        try {
            type.getDeclaredConstructor(new Class[0]);
            return type;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class must have default constructor: " + type.getName());
        }
    }

    private void ensureNotStale() {
        if (this.isStale) {
            throw new IllegalStateException("Mapper builder can't be reused.");
        }
    }

    private String requireValidField(String fieldName) {
        try {
            if (fieldName == null || this.targetType.getDeclaredField(fieldName) == null) {
                throw new IllegalArgumentException("Mapping for a column already exists: " + fieldName);
            }
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Field not found for class: field=%s, class=%s", fieldName, this.targetType.getName()));
        }
        return fieldName;
    }

    public MapperBuilder<T> map(@NotNull String fieldName, @NotNull String columnName, String ... fieldColumnPairs) {
        this.ensureNotStale();
        String colName0 = IgniteNameUtils.parseSimpleName((String)columnName);
        if (this.columnToFields == null) {
            throw new IllegalArgumentException("Natively supported types doesn't support field mapping.");
        }
        if (fieldColumnPairs.length % 2 != 0) {
            throw new IllegalArgumentException("fieldColumnPairs length should be even.");
        }
        if (this.columnToFields.put(Objects.requireNonNull(colName0), this.requireValidField(fieldName)) != null) {
            throw new IllegalArgumentException("Mapping for a column already exists: " + colName0);
        }
        for (int i = 0; i < fieldColumnPairs.length; i += 2) {
            if (this.columnToFields.put(IgniteNameUtils.parseSimpleName((String)Objects.requireNonNull(fieldColumnPairs[i + 1])), this.requireValidField(fieldColumnPairs[i])) == null) continue;
            throw new IllegalArgumentException("Mapping for a column already exists: " + colName0);
        }
        return this;
    }

    public <ObjectT, ColumnT> MapperBuilder<T> map(@NotNull String fieldName, @NotNull String columnName, @NotNull TypeConverter<ObjectT, ColumnT> converter) {
        this.map(fieldName, columnName, new String[0]);
        this.convert(columnName, converter);
        return this;
    }

    public <ObjectT, ColumnT> MapperBuilder<T> convert(@NotNull String columnName, @NotNull TypeConverter<ObjectT, ColumnT> converter) {
        this.ensureNotStale();
        if (this.columnConverters.put(IgniteNameUtils.parseSimpleName((String)columnName), converter) != null) {
            throw new IllegalArgumentException("Column converter already exists: " + columnName);
        }
        return this;
    }

    public MapperBuilder<T> automap() {
        this.ensureNotStale();
        this.automapFlag = true;
        return this;
    }

    public Mapper<T> build() {
        this.ensureNotStale();
        this.isStale = true;
        if (this.columnToFields == null) {
            return new OneColumnMapperImpl<T>(this.targetType, this.mappedToColumn, this.columnConverters.get(this.mappedToColumn));
        }
        Map<String, String> mapping = this.columnToFields;
        HashSet<String> fields = new HashSet<String>(mapping.size());
        for (String fldName2 : mapping.values()) {
            if (fields.add(fldName2)) continue;
            throw new IllegalStateException("More than one column is mapped to the field: field=" + fldName2);
        }
        if (this.automapFlag) {
            Arrays.stream(this.targetType.getDeclaredFields()).map(Field::getName).filter(fldName -> !fields.contains(fldName)).forEach(fldName -> mapping.putIfAbsent(fldName.toUpperCase(), (String)fldName));
        }
        return new PojoMapperImpl<T>(this.targetType, mapping, this.columnConverters);
    }
}

