/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.exception;

import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElement;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;

public interface ExceptionHandler<T extends Throwable> {
    public static final IgniteLogger LOG = Loggers.forClass(ExceptionHandler.class);
    public static final ExceptionHandler<Throwable> DEFAULT = new ExceptionHandler<Throwable>(){

        @Override
        public int handle(ExceptionWriter err, Throwable e) {
            LOG.error("Unhandled exception", e);
            err.write(ErrorUiComponent.builder().header("Unknown error", new UiElement[0]).details(e.getMessage(), new UiElement[0]).build().render());
            return 1;
        }

        @Override
        public Class<Throwable> applicableException() {
            return Throwable.class;
        }
    };

    public int handle(ExceptionWriter var1, T var2);

    public Class<T> applicableException();
}

