/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.configuration;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.configuration.JsonString;
import org.apache.ignite.internal.cli.call.configuration.NodeConfigShowCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.rest.client.api.NodeConfigurationApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.Configuration;

@Singleton
public class NodeConfigShowCall
implements Call<NodeConfigShowCallInput, JsonString> {
    @Override
    public DefaultCallOutput<JsonString> execute(NodeConfigShowCallInput input) {
        NodeConfigurationApi client = this.createApiClient(input);
        try {
            return DefaultCallOutput.success(this.readNodeConfig(client, input));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getNodeUrl()));
        }
    }

    private JsonString readNodeConfig(NodeConfigurationApi api, NodeConfigShowCallInput input) throws ApiException {
        return JsonString.fromString(input.getSelector() != null ? api.getNodeConfigurationByPath(input.getSelector()) : api.getNodeConfiguration());
    }

    private NodeConfigurationApi createApiClient(NodeConfigShowCallInput input) {
        return new NodeConfigurationApi(Configuration.getDefaultApiClient().setBasePath(input.getNodeUrl()));
    }
}

