/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;

public class PendingComparableValuesTracker<T extends Comparable<T>> {
    private final ConcurrentSkipListMap<T, Collection<CompletableFuture<Void>>> valueFutures = new ConcurrentSkipListMap();
    public final AtomicReference<T> current;

    public PendingComparableValuesTracker(T initialValue) {
        this.current = new AtomicReference<T>(initialValue);
    }

    public void update(T newValue) {
        Comparable current;
        for (Map.Entry<T, Collection<CompletableFuture<Void>>> e : this.valueFutures.entrySet()) {
            if (newValue.compareTo((Comparable)((Comparable)e.getKey())) < 0) break;
            this.valueFutures.compute((Comparable)e.getKey(), (k, v) -> {
                if (v != null) {
                    v.forEach(f -> f.complete(null));
                }
                return null;
            });
        }
        while (newValue.compareTo((Comparable)(current = (Comparable)this.current.get())) > 0) {
            if (!this.current.compareAndSet(current, newValue)) continue;
            return;
        }
    }

    public CompletableFuture<Void> waitFor(T valueToWait) {
        if (((Comparable)this.current.get()).compareTo(valueToWait) >= 0) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.valueFutures.compute(valueToWait, (k, v) -> {
            if (v == null) {
                v = new ConcurrentLinkedDeque<CompletableFuture>();
            }
            v.add(future);
            return v;
        });
        if (((Comparable)this.current.get()).compareTo(valueToWait) >= 0) {
            future.complete(null);
            this.valueFutures.compute(valueToWait, (k, v) -> {
                if (v == null) {
                    return null;
                }
                v.remove(future);
                return v;
            });
        }
        return future;
    }

    public T current() {
        return (T)((Comparable)this.current.get());
    }
}

