/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.future;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class InFlightFutures
implements Iterable<CompletableFuture<?>> {
    private final Set<CompletableFuture<?>> inFlightFutures = ConcurrentHashMap.newKeySet();

    public void registerFuture(CompletableFuture<?> future) {
        this.inFlightFutures.add(future);
        future.whenComplete((result, ex) -> this.inFlightFutures.remove(future));
    }

    public void cancelInFlightFutures() {
        for (CompletableFuture<?> future : this) {
            future.cancel(true);
        }
    }

    @Override
    public Iterator<CompletableFuture<?>> iterator() {
        return this.inFlightFutures.iterator();
    }
}

