/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;

@InterfaceAudience.Private
public class SerialNumberMap<T> {
    private String name;
    private final int max;
    private final AtomicInteger current = new AtomicInteger(1);
    private final ConcurrentMap<T, Integer> t2i = new ConcurrentHashMap<T, Integer>();
    private final ConcurrentMap<Integer, T> i2t = new ConcurrentHashMap<Integer, T>();

    SerialNumberMap(SerialNumberManager snm) {
        this(snm.name(), snm.getLength());
    }

    SerialNumberMap(String name, int bitLength) {
        this.name = name;
        this.max = (1 << bitLength) - 1;
    }

    public int get(T t) {
        if (t == null) {
            return 0;
        }
        Integer sn = (Integer)this.t2i.get(t);
        if (sn == null) {
            sn = this.current.getAndIncrement();
            if (sn > this.max) {
                this.current.getAndDecrement();
                throw new IllegalStateException(this.name + ": serial number map is full");
            }
            Integer old = this.t2i.putIfAbsent(t, sn);
            if (old != null) {
                return old;
            }
            this.i2t.put(sn, t);
        }
        return sn;
    }

    public T get(int i) {
        if (i == 0) {
            return null;
        }
        Object t = this.i2t.get(i);
        if (t == null) {
            throw new IllegalStateException(this.name + ": serial number " + i + " does not exist");
        }
        return (T)t;
    }

    int getMax() {
        return this.max;
    }

    Set<Map.Entry<Integer, T>> entrySet() {
        return new HashSet<Map.Entry<Integer, T>>(this.i2t.entrySet());
    }

    public int size() {
        return this.i2t.size();
    }

    public String toString() {
        return "current=" + this.current + ",\n" + "max=" + this.max + ",\n  t2i=" + this.t2i + ",\n  i2t=" + this.i2t;
    }
}

