/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.socksx.v5;

import java.util.List;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufUtil;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.handler.codec.DecoderException;
import org.apache.hbase.thirdparty.io.netty.handler.codec.DecoderResult;
import org.apache.hbase.thirdparty.io.netty.handler.codec.ReplayingDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.socksx.SocksVersion;
import org.apache.hbase.thirdparty.io.netty.handler.codec.socksx.v5.DefaultSocks5CommandRequest;
import org.apache.hbase.thirdparty.io.netty.handler.codec.socksx.v5.Socks5AddressDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import org.apache.hbase.thirdparty.io.netty.handler.codec.socksx.v5.Socks5CommandType;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

public class Socks5CommandRequestDecoder
extends ReplayingDecoder<State> {
    private final Socks5AddressDecoder addressDecoder;

    public Socks5CommandRequestDecoder() {
        this(Socks5AddressDecoder.DEFAULT);
    }

    public Socks5CommandRequestDecoder(Socks5AddressDecoder addressDecoder) {
        super(State.INIT);
        this.addressDecoder = ObjectUtil.checkNotNull(addressDecoder, "addressDecoder");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            switch ((State)((Object)this.state())) {
                case INIT: {
                    byte version = in.readByte();
                    if (version != SocksVersion.SOCKS5.byteValue()) {
                        throw new DecoderException("unsupported version: " + version + " (expected: " + SocksVersion.SOCKS5.byteValue() + ')');
                    }
                    Socks5CommandType type = Socks5CommandType.valueOf(in.readByte());
                    in.skipBytes(1);
                    Socks5AddressType dstAddrType = Socks5AddressType.valueOf(in.readByte());
                    String dstAddr = this.addressDecoder.decodeAddress(dstAddrType, in);
                    int dstPort = ByteBufUtil.readUnsignedShortBE(in);
                    out.add(new DefaultSocks5CommandRequest(type, dstAddrType, dstAddr, dstPort));
                    this.checkpoint(State.SUCCESS);
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    out.add(in.readRetainedSlice(readableBytes));
                    break;
                }
                case FAILURE: {
                    in.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(out, e);
        }
    }

    private void fail(List<Object> out, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException(cause);
        }
        this.checkpoint(State.FAILURE);
        DefaultSocks5CommandRequest m = new DefaultSocks5CommandRequest(Socks5CommandType.CONNECT, Socks5AddressType.IPv4, "0.0.0.0", 1);
        m.setDecoderResult(DecoderResult.failure(cause));
        out.add(m);
    }

    public static enum State {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

