/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.provider.AttemptingUserProvidingSaslServer;
import org.apache.hadoop.hbase.security.provider.SaslAuthMethod;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProviders;
import org.apache.hadoop.hbase.security.provider.SimpleSaslServerAuthenticationProvider;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, SecurityTests.class})
public class TestSaslServerAuthenticationProviders {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSaslServerAuthenticationProviders.class);

    @Before
    public void reset() {
        SaslServerAuthenticationProviders.reset();
    }

    @Test
    public void testCannotAddTheSameProviderTwice() {
        HashMap registeredProviders = new HashMap();
        SimpleSaslServerAuthenticationProvider p1 = new SimpleSaslServerAuthenticationProvider();
        SimpleSaslServerAuthenticationProvider p2 = new SimpleSaslServerAuthenticationProvider();
        SaslServerAuthenticationProviders.addProviderIfNotExists((SaslServerAuthenticationProvider)p1, registeredProviders);
        Assert.assertEquals((long)1L, (long)registeredProviders.size());
        try {
            SaslServerAuthenticationProviders.addProviderIfNotExists((SaslServerAuthenticationProvider)p2, registeredProviders);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertSame((String)"Expected the original provider to be present", (Object)p1, registeredProviders.entrySet().iterator().next().getValue());
    }

    @Test
    public void testInstanceIsCached() {
        Configuration conf = HBaseConfiguration.create();
        SaslServerAuthenticationProviders providers1 = SaslServerAuthenticationProviders.getInstance((Configuration)conf);
        SaslServerAuthenticationProviders providers2 = SaslServerAuthenticationProviders.getInstance((Configuration)conf);
        Assert.assertSame((Object)providers1, (Object)providers2);
        SaslServerAuthenticationProviders.reset();
        SaslServerAuthenticationProviders providers3 = SaslServerAuthenticationProviders.getInstance((Configuration)conf);
        Assert.assertNotSame((Object)providers1, (Object)providers3);
        Assert.assertEquals((long)providers1.getNumRegisteredProviders(), (long)providers3.getNumRegisteredProviders());
    }

    @Test
    public void instancesAreInitialized() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.server.sasl.provider.extras", InitCheckingSaslServerAuthenticationProvider.class.getName());
        SaslServerAuthenticationProviders providers = SaslServerAuthenticationProviders.getInstance((Configuration)conf);
        SaslServerAuthenticationProvider provider = providers.selectProvider((byte)88);
        Assert.assertEquals(InitCheckingSaslServerAuthenticationProvider.class, provider.getClass());
        Assert.assertTrue((String)"Provider was not inititalized", (boolean)((InitCheckingSaslServerAuthenticationProvider)provider).isInitialized());
    }

    public static class InitCheckingSaslServerAuthenticationProvider
    implements SaslServerAuthenticationProvider {
        public static final byte ID = 88;
        private boolean initialized = false;

        public synchronized void init(Configuration conf) {
            this.initialized = true;
        }

        public synchronized boolean isInitialized() {
            return this.initialized;
        }

        public SaslAuthMethod getSaslAuthMethod() {
            return new SaslAuthMethod("INIT_CHECKING", 88, "DIGEST-MD5", UserGroupInformation.AuthenticationMethod.TOKEN);
        }

        public String getTokenKind() {
            return "INIT_CHECKING_TOKEN";
        }

        public AttemptingUserProvidingSaslServer createServer(SecretManager<TokenIdentifier> secretManager, Map<String, String> saslProps) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean supportsProtocolAuthentication() {
            return false;
        }

        public UserGroupInformation getAuthorizedUgi(String authzId, SecretManager<TokenIdentifier> secretManager) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

