/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.AbstractTestDateTieredCompactionPolicy;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestDateTieredCompactionPolicyHeterogeneousStorage
extends AbstractTestDateTieredCompactionPolicy {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDateTieredCompactionPolicyHeterogeneousStorage.class);
    public static final String HOT_WINDOW_SP = "ALL_SSD";
    public static final String WARM_WINDOW_SP = "ONE_SSD";
    public static final String COLD_WINDOW_SP = "HOT";

    @Override
    protected void config() {
        super.config();
        this.conf.set("hbase.hstore.engine.class", "org.apache.hadoop.hbase.regionserver.DateTieredStoreEngine");
        this.conf.setLong("hbase.hstore.compaction.date.tiered.max.storefile.age.millis", 100L);
        this.conf.setLong("hbase.hstore.compaction.date.tiered.incoming.window.min", 3L);
        this.conf.setLong("hbase.hstore.compaction.date.tiered.base.window.millis", 6L);
        this.conf.setInt("hbase.hstore.compaction.date.tiered.windows.per.tier", 4);
        this.conf.setBoolean("hbase.hstore.compaction.date.tiered.single.output.for.minor.compaction", false);
        this.conf.setInt("hbase.hstore.compaction.min", 2);
        this.conf.setInt("hbase.hstore.compaction.max", 12);
        this.conf.setFloat("hbase.hstore.compaction.ratio", 1.2f);
        this.conf.setInt("hbase.hstore.blockingStoreFiles", 20);
        this.conf.setLong("hbase.hregion.majorcompaction", 5L);
        this.conf.setBoolean("hbase.hstore.compaction.date.tiered.storage.policy.enable", true);
        this.conf.setLong("hbase.hstore.compaction.date.tiered.hot.window.age.millis", 6L);
        this.conf.set("hbase.hstore.compaction.date.tiered.hot.window.storage.policy", HOT_WINDOW_SP);
        this.conf.setLong("hbase.hstore.compaction.date.tiered.warm.window.age.millis", 12L);
        this.conf.set("hbase.hstore.compaction.date.tiered.warm.window.storage.policy", WARM_WINDOW_SP);
        this.conf.set("hbase.hstore.compaction.date.tiered.cold.window.storage.policy", COLD_WINDOW_SP);
    }

    @Test
    public void testIncomingWindowHot() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 23L, 24L, 25L, 10L, 11L, 12L, 13L};
        HashMap<Long, String> expected = new HashMap<Long, String>();
        expected.put(12L, HOT_WINDOW_SP);
        this.compactEqualsStoragePolicy(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), expected, false, true);
    }

    @Test
    public void testNotIncomingWindowWarm() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 23L, 24L, 25L, 10L, 11L};
        HashMap<Long, String> expected = new HashMap<Long, String>();
        expected.put(6L, WARM_WINDOW_SP);
        this.compactEqualsStoragePolicy(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), expected, false, true);
    }

    @Test
    public void testNotIncomingWindowAndIsHot() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 23L, 24L, 25L, 10L, 11L};
        HashMap<Long, String> expected = new HashMap<Long, String>();
        expected.put(6L, HOT_WINDOW_SP);
        this.compactEqualsStoragePolicy(12L, this.sfCreate(minTimestamps, maxTimestamps, sizes), expected, false, true);
    }

    @Test
    public void testColdWindow() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 23L, 24L, 25L, 10L};
        HashMap<Long, String> expected = new HashMap<Long, String>();
        expected.put(6L, COLD_WINDOW_SP);
        this.compactEqualsStoragePolicy(22L, this.sfCreate(minTimestamps, maxTimestamps, sizes), expected, false, true);
    }

    @Test
    public void testRatioT0() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 280L, 23L, 24L, 1L};
        HashMap<Long, String> expected = new HashMap<Long, String>();
        expected.put(Long.MIN_VALUE, WARM_WINDOW_SP);
        this.compactEqualsStoragePolicy(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), expected, false, true);
    }

    @Test
    public void testMajorCompation() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{44L, 60L, 61L, 96L, 100L, 104L, 105L, 106L, 113L, 145L, 157L};
        long[] sizes = new long[]{0L, 50L, 51L, 40L, 41L, 42L, 33L, 30L, 31L, 2L, 1L};
        HashMap<Long, String> expected = new HashMap<Long, String>();
        expected.put(Long.MIN_VALUE, COLD_WINDOW_SP);
        expected.put(24L, COLD_WINDOW_SP);
        expected.put(48L, COLD_WINDOW_SP);
        expected.put(72L, COLD_WINDOW_SP);
        expected.put(96L, COLD_WINDOW_SP);
        expected.put(120L, COLD_WINDOW_SP);
        expected.put(144L, COLD_WINDOW_SP);
        expected.put(150L, WARM_WINDOW_SP);
        expected.put(156L, HOT_WINDOW_SP);
        this.compactEquals(161L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{0L, 50L, 51L, 40L, 41L, 42L, 33L, 30L, 31L, 2L, 1L}, new long[]{Long.MIN_VALUE, 24L, 48L, 72L, 96L, 120L, 144L, 150L, 156L}, true, true);
        this.compactEqualsStoragePolicy(161L, this.sfCreate(minTimestamps, maxTimestamps, sizes), expected, true, true);
    }
}

