/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.BadMasterObserverForCreateDeleteTable;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCreateDeleteTableProcedureWithRetry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCreateDeleteTableProcedureWithRetry.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)TestCreateDeleteTableProcedureWithRetry.class.getSimpleName());
    private static final String CF = "cf";

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", BadMasterObserverForCreateDeleteTable.class.getName());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCreateDeleteTableRetry() throws IOException {
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        TableDescriptor htd = MasterProcedureTestingUtility.createHTD(TABLE_NAME, CF);
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])null);
        CreateTableProcedure createProc = new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions);
        ProcedureTestingUtility.submitAndWait((ProcedureExecutor)procExec, (Procedure)createProc);
        Assert.assertTrue((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getMiniHBaseCluster().getMaster(), TABLE_NAME, regions, CF);
        UTIL.getAdmin().disableTable(TABLE_NAME);
        DeleteTableProcedure deleteProc = new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), TABLE_NAME);
        ProcedureTestingUtility.submitAndWait((ProcedureExecutor)procExec, (Procedure)deleteProc);
        Assert.assertFalse((boolean)UTIL.getAdmin().tableExists(TABLE_NAME));
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getMiniHBaseCluster().getMaster(), TABLE_NAME);
    }
}

