/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, MasterTests.class})
public class TestClientMetaServiceRPCs {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientMetaServiceRPCs.class);
    private static final int MASTER_COUNT = 3;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static int rpcTimeout;
    private static RpcClient rpcClient;

    @BeforeClass
    public static void setUp() throws Exception {
        StartMiniClusterOption.Builder builder = StartMiniClusterOption.builder();
        builder.numMasters(3).numRegionServers(3);
        TEST_UTIL.startMiniCluster(builder.build());
        conf = TEST_UTIL.getConfiguration();
        rpcTimeout = (int)Math.min(Integer.MAX_VALUE, TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.rpc.timeout", 60000L)));
        rpcClient = RpcClientFactory.createClient((Configuration)conf, (String)TEST_UTIL.getMiniHBaseCluster().getMaster().getClusterId());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (rpcClient != null) {
            rpcClient.close();
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    private static RegistryProtos.ClientMetaService.BlockingInterface getMasterStub(ServerName server) throws IOException {
        return RegistryProtos.ClientMetaService.newBlockingStub((BlockingRpcChannel)rpcClient.createBlockingRpcChannel(server, User.getCurrent(), rpcTimeout));
    }

    private static HBaseRpcController getRpcController() {
        return RpcControllerFactory.instantiate((Configuration)conf).newController();
    }

    @Test
    public void TestClusterID() throws Exception {
        HBaseRpcController rpcController = TestClientMetaServiceRPCs.getRpcController();
        String clusterID = TEST_UTIL.getMiniHBaseCluster().getMaster().getClusterId();
        int rpcCount = 0;
        for (JVMClusterUtil.MasterThread masterThread : TEST_UTIL.getMiniHBaseCluster().getMasterThreads()) {
            RegistryProtos.ClientMetaService.BlockingInterface stub = TestClientMetaServiceRPCs.getMasterStub(masterThread.getMaster().getServerName());
            RegistryProtos.GetClusterIdResponse resp = stub.getClusterId((RpcController)rpcController, RegistryProtos.GetClusterIdRequest.getDefaultInstance());
            Assert.assertEquals((Object)clusterID, (Object)resp.getClusterId());
            ++rpcCount;
        }
        Assert.assertEquals((long)3L, (long)rpcCount);
    }

    @Test
    public void TestActiveMaster() throws Exception {
        HBaseRpcController rpcController = TestClientMetaServiceRPCs.getRpcController();
        ServerName activeMaster = TEST_UTIL.getMiniHBaseCluster().getMaster().getServerName();
        int rpcCount = 0;
        for (JVMClusterUtil.MasterThread masterThread : TEST_UTIL.getMiniHBaseCluster().getMasterThreads()) {
            RegistryProtos.ClientMetaService.BlockingInterface stub = TestClientMetaServiceRPCs.getMasterStub(masterThread.getMaster().getServerName());
            RegistryProtos.GetActiveMasterResponse resp = stub.getActiveMaster((RpcController)rpcController, RegistryProtos.GetActiveMasterRequest.getDefaultInstance());
            Assert.assertEquals((Object)activeMaster, (Object)ProtobufUtil.toServerName((HBaseProtos.ServerName)resp.getServerName()));
            ++rpcCount;
        }
        Assert.assertEquals((long)3L, (long)rpcCount);
    }

    @Test
    public void TestMetaLocations() throws Exception {
        HBaseRpcController rpcController = TestClientMetaServiceRPCs.getRpcController();
        List metaLocations = (List)TEST_UTIL.getMiniHBaseCluster().getMaster().getMetaRegionLocationCache().getMetaRegionLocations().get();
        Collections.sort(metaLocations);
        int rpcCount = 0;
        for (JVMClusterUtil.MasterThread masterThread : TEST_UTIL.getMiniHBaseCluster().getMasterThreads()) {
            RegistryProtos.ClientMetaService.BlockingInterface stub = TestClientMetaServiceRPCs.getMasterStub(masterThread.getMaster().getServerName());
            RegistryProtos.GetMetaRegionLocationsResponse resp = stub.getMetaRegionLocations((RpcController)rpcController, RegistryProtos.GetMetaRegionLocationsRequest.getDefaultInstance());
            ArrayList result = new ArrayList();
            resp.getMetaLocationsList().forEach(location -> result.add(ProtobufUtil.toRegionLocation((HBaseProtos.RegionLocation)location)));
            Collections.sort(result);
            Assert.assertEquals((Object)metaLocations, result);
            ++rpcCount;
        }
        Assert.assertEquals((long)3L, (long)rpcCount);
    }
}

