/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestCheckAndMutate {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCheckAndMutate.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROWKEY = Bytes.toBytes((String)"12345");
    private static final byte[] ROWKEY2 = Bytes.toBytes((String)"67890");
    private static final byte[] ROWKEY3 = Bytes.toBytes((String)"abcde");
    private static final byte[] ROWKEY4 = Bytes.toBytes((String)"fghij");
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private Table createTable() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        TEST_UTIL.waitTableAvailable(tableName.getName(), 5000L);
        return table;
    }

    private void putOneRow(Table table) throws IOException {
        Put put = new Put(ROWKEY);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
        table.put(put);
    }

    private void getOneRowAndAssertAllExist(Table table) throws IOException {
        Get get = new Get(ROWKEY);
        Result result = table.get(get);
        Assert.assertTrue((String)"Column A value should be a", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))).equals("a"));
        Assert.assertTrue((String)"Column B value should be b", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))).equals("b"));
        Assert.assertTrue((String)"Column C value should be c", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))).equals("c"));
    }

    private void getOneRowAndAssertAllButCExist(Table table) throws IOException {
        Get get = new Get(ROWKEY);
        Result result = table.get(get);
        Assert.assertTrue((String)"Column A value should be a", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))).equals("a"));
        Assert.assertTrue((String)"Column B value should be b", (boolean)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))).equals("b"));
        Assert.assertTrue((String)"Column C should not exist", (result.getValue(FAMILY, Bytes.toBytes((String)"C")) == null ? 1 : 0) != 0);
    }

    private RowMutations makeRowMutationsWithColumnCDeleted() throws IOException {
        RowMutations rm = new RowMutations(ROWKEY, 2);
        Put put = new Put(ROWKEY);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        rm.add(put);
        Delete del = new Delete(ROWKEY);
        del.addColumn(FAMILY, Bytes.toBytes((String)"C"));
        rm.add(del);
        return rm;
    }

    private RowMutations getBogusRowMutations() throws IOException {
        Put p = new Put(ROWKEY);
        byte[] value = new byte[]{};
        p.addColumn(new byte[]{98, 111, 103, 117, 115}, new byte[]{65}, value);
        RowMutations rm = new RowMutations(ROWKEY);
        rm.add(p);
        return rm;
    }

    @Test
    @Deprecated
    public void testCheckAndMutateForOldApi() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            RowMutations rm = this.makeRowMutationsWithColumnCDeleted();
            boolean res = table.checkAndMutate(ROWKEY, FAMILY).qualifier(Bytes.toBytes((String)"A")).ifEquals(Bytes.toBytes((String)"a")).thenMutate(rm);
            Assert.assertTrue((boolean)res);
            this.getOneRowAndAssertAllButCExist(table);
            try {
                rm = this.getBogusRowMutations();
                table.checkAndMutate(ROWKEY, FAMILY).qualifier(Bytes.toBytes((String)"A")).ifEquals(Bytes.toBytes((String)"a")).thenMutate(rm);
                Assert.fail((String)"Expected NoSuchColumnFamilyException");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                try {
                    throw e.getCause(0);
                }
                catch (NoSuchColumnFamilyException noSuchColumnFamilyException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    @Deprecated
    public void testCheckAndMutateWithSingleFilterForOldApi() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            boolean ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
            Assert.assertTrue((boolean)ok);
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")));
            Assert.assertFalse((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).thenDelete(new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertTrue((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).thenMutate(new RowMutations(ROWKEY).add((Mutation)new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"A"))));
            Assert.assertTrue((boolean)ok);
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"))));
        }
    }

    @Test
    @Deprecated
    public void testCheckAndMutateWithMultipleFiltersForOldApi() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            boolean ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
            Assert.assertTrue((boolean)ok);
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")));
            Assert.assertFalse((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).thenDelete(new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertTrue((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).thenMutate(new RowMutations(ROWKEY).add((Mutation)new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"A"))));
            Assert.assertTrue((boolean)ok);
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"))));
        }
    }

    @Test
    @Deprecated
    public void testCheckAndMutateWithTimestampFilterForOldApi() throws Throwable {
        try (Table table = this.createTable();){
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")));
            boolean ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(100L))})).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")));
            Assert.assertTrue((boolean)ok);
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(101L))})).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
            Assert.assertFalse((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"))));
        }
    }

    @Test
    @Deprecated
    public void testCheckAndMutateWithFilterAndTimeRangeForOldApi() throws Throwable {
        try (Table table = this.createTable();){
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")));
            boolean ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)101L)).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")));
            Assert.assertTrue((boolean)ok);
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            ok = table.checkAndMutate(ROWKEY, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)100L)).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
            Assert.assertFalse((boolean)ok);
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"))));
        }
    }

    @Test(expected=NullPointerException.class)
    @Deprecated
    public void testCheckAndMutateWithoutConditionForOldApi() throws Throwable {
        try (Table table = this.createTable();){
            table.checkAndMutate(ROWKEY, FAMILY).thenPut(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
        }
    }

    @Test
    public void testCheckAndMutate() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            RowMutations rm = this.makeRowMutationsWithColumnCDeleted();
            CheckAndMutateResult res = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(rm));
            Assert.assertTrue((boolean)res.isSuccess());
            Assert.assertNull((Object)res.getResult());
            this.getOneRowAndAssertAllButCExist(table);
            try {
                rm = this.getBogusRowMutations();
                table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(rm));
                Assert.fail((String)"Expected NoSuchColumnFamilyException");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                try {
                    throw e.getCause(0);
                }
                catch (NoSuchColumnFamilyException noSuchColumnFamilyException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testCheckAndMutateWithSingleFilter() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            CheckAndMutateResult result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))));
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Result r = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e"))));
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"))));
            result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).build(new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"))));
            result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))).build(new RowMutations(ROWKEY).add((Mutation)new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"A")))));
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            r = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"))));
        }
    }

    @Test
    public void testCheckAndMutateWithMultipleFilters() throws Throwable {
        try (Table table = this.createTable();){
            this.putOneRow(table);
            this.getOneRowAndAssertAllExist(table);
            CheckAndMutateResult result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))));
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Result r = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e"))));
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"E"))));
            result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"))));
            result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new RowMutations(ROWKEY).add((Mutation)new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"A")))));
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            r = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"))));
        }
    }

    @Test
    public void testCheckAndMutateWithTimestampFilter() throws Throwable {
        try (Table table = this.createTable();){
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")));
            CheckAndMutateResult result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(100L))})).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"))));
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Result r = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILY)), new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"A"))), new TimestampsFilter(Collections.singletonList(101L))})).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"))));
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"))));
        }
    }

    @Test
    public void testCheckAndMutateWithFilterAndTimeRange() throws Throwable {
        try (Table table = this.createTable();){
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")));
            CheckAndMutateResult result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)101L)).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"))));
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Result r = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            result = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)100L)).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"))));
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"))));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testCheckAndMutateBuilderWithoutCondition() {
        CheckAndMutate.newBuilder((byte[])ROWKEY).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
    }

    @Test
    public void testCheckAndIncrement() throws Throwable {
        try (Table table = this.createTable();){
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")));
            CheckAndMutateResult res = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Increment(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), 1L)));
            Assert.assertTrue((boolean)res.isSuccess());
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            res = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"b")).build(new Increment(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), 1L)));
            Assert.assertFalse((boolean)res.isSuccess());
            Assert.assertNull((Object)res.getResult());
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
            res = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).build(new Increment(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), 2L)));
            Assert.assertTrue((boolean)res.isSuccess());
            Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            res = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"d"))})).build(new Increment(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), 2L)));
            Assert.assertFalse((boolean)res.isSuccess());
            Assert.assertNull((Object)res.getResult());
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        }
    }

    @Test
    public void testCheckAndAppend() throws Throwable {
        try (Table table = this.createTable();){
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")));
            CheckAndMutateResult res = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Append(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"))));
            Assert.assertTrue((boolean)res.isSuccess());
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            res = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"b")).build(new Append(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"))));
            Assert.assertFalse((boolean)res.isSuccess());
            Assert.assertNull((Object)res.getResult());
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            table.put(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
            res = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).build(new Append(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"bb"))));
            Assert.assertTrue((boolean)res.isSuccess());
            Assert.assertEquals((Object)"bbb", (Object)Bytes.toString((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"bbb", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            res = table.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"d"))})).build(new Append(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"bb"))));
            Assert.assertFalse((boolean)res.isSuccess());
            Assert.assertNull((Object)res.getResult());
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"bbb", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        }
    }

    @Test
    public void testCheckAndRowMutations() throws Throwable {
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] q3 = Bytes.toBytes((String)"q3");
        byte[] q4 = Bytes.toBytes((String)"q4");
        String v1 = "v1";
        try (Table table = this.createTable();){
            table.put(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, q2, Bytes.toBytes((String)"toBeDeleted")), new Put(ROWKEY).addColumn(FAMILY, q3, Bytes.toBytes((long)5L)), new Put(ROWKEY).addColumn(FAMILY, q4, Bytes.toBytes((String)"a"))));
            CheckAndMutate checkAndMutate = CheckAndMutate.newBuilder((byte[])ROWKEY).ifNotExists(FAMILY, q1).build(new RowMutations(ROWKEY).add(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, q1, Bytes.toBytes((String)"v1")), new Delete(ROWKEY).addColumns(FAMILY, q2), new Increment(ROWKEY).addColumn(FAMILY, q3, 1L), new Append(ROWKEY).addColumn(FAMILY, q4, Bytes.toBytes((String)"b")))));
            CheckAndMutateResult result = table.checkAndMutate(checkAndMutate);
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])result.getResult().getValue(FAMILY, q3)));
            Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])result.getResult().getValue(FAMILY, q4)));
            Result r = table.get(new Get(ROWKEY));
            Assert.assertEquals((Object)"v1", (Object)Bytes.toString((byte[])r.getValue(FAMILY, q1)));
            Assert.assertNull((Object)r.getValue(FAMILY, q2));
            Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])r.getValue(FAMILY, q3)));
            Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])r.getValue(FAMILY, q4)));
            checkAndMutate = CheckAndMutate.newBuilder((byte[])ROWKEY).ifNotExists(FAMILY, q1).build(new RowMutations(ROWKEY).add(Arrays.asList(new Delete(ROWKEY).addColumns(FAMILY, q1), new Put(ROWKEY).addColumn(FAMILY, q2, Bytes.toBytes((String)"v1")), new Increment(ROWKEY).addColumn(FAMILY, q3, 1L), new Append(ROWKEY).addColumn(FAMILY, q4, Bytes.toBytes((String)"b")))));
            result = table.checkAndMutate(checkAndMutate);
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertNull((Object)result.getResult());
            r = table.get(new Get(ROWKEY));
            Assert.assertEquals((Object)"v1", (Object)Bytes.toString((byte[])r.getValue(FAMILY, q1)));
            Assert.assertNull((Object)r.getValue(FAMILY, q2));
            Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])r.getValue(FAMILY, q3)));
            Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])r.getValue(FAMILY, q4)));
        }
    }

    @Test
    public void testCheckAndMutateBatch() throws Throwable {
        try (Table table = this.createTable();){
            table.put(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")), new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")), new Put(ROWKEY3).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")), new Put(ROWKEY4).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))));
            CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"e")));
            CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifEquals(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"a")).build(new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"f")));
            List results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A")));
            Assert.assertEquals((Object)"e", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
            result = table.get(new Get(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"e")).build(new Delete(ROWKEY));
            checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifEquals(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"a")).build(new Delete(ROWKEY2));
            results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"))));
            result = table.get(new Get(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY3).ifEquals(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")).build(new RowMutations(ROWKEY3).add((Mutation)new Put(ROWKEY3).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f"))).add((Mutation)new Delete(ROWKEY3).addColumns(FAMILY, Bytes.toBytes((String)"C"))));
            checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY4).ifEquals(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"f")).build(new RowMutations(ROWKEY4).add((Mutation)new Put(ROWKEY4).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f"))).add((Mutation)new Delete(ROWKEY4).addColumns(FAMILY, Bytes.toBytes((String)"D"))));
            results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            result = table.get(new Get(ROWKEY3));
            Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
            Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"D")));
            result = table.get(new Get(ROWKEY4));
            Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"F")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        }
    }

    @Test
    public void testCheckAndMutateBatch2() throws Throwable {
        try (Table table = this.createTable();){
            table.put(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")), new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")), new Put(ROWKEY3).addColumn(FAMILY, Bytes.toBytes((String)"C"), 100L, Bytes.toBytes((String)"c")), new Put(ROWKEY4).addColumn(FAMILY, Bytes.toBytes((String)"D"), 100L, Bytes.toBytes((String)"d"))));
            CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifNotExists(FAMILY, Bytes.toBytes((String)"B")).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"e")));
            CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifNotExists(FAMILY, Bytes.toBytes((String)"B")).build(new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"f")));
            List results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A")));
            Assert.assertEquals((Object)"e", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
            result = table.get(new Get(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.NOT_EQUAL, Bytes.toBytes((String)"a")).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")));
            checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifMatches(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.GREATER, Bytes.toBytes((String)"b")).build(new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"f")));
            results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A")));
            Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
            result = table.get(new Get(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY3).ifEquals(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")).timeRange(TimeRange.between((long)0L, (long)101L)).build(new Put(ROWKEY3).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"e")));
            checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY4).ifEquals(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")).timeRange(TimeRange.between((long)0L, (long)100L)).build(new Put(ROWKEY4).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"f")));
            results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            result = table.get(new Get(ROWKEY3).addColumn(FAMILY, Bytes.toBytes((String)"C")));
            Assert.assertEquals((Object)"e", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
            result = table.get(new Get(ROWKEY4).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        }
    }

    @Test
    public void testCheckAndMutateBatchWithFilter() throws Throwable {
        try (Table table = this.createTable();){
            table.put(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")), new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f"))));
            CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"g")));
            CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"D"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"E"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"h")));
            List results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C")));
            Assert.assertEquals((Object)"g", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
            result = table.get(new Get(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"F")));
            Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
            checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"C")));
            checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"D"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"E"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Delete(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"F")));
            results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            Assert.assertFalse((boolean)table.exists(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"))));
            result = table.get(new Get(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"F")));
            Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
            checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new RowMutations(ROWKEY).add((Mutation)new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"))).add((Mutation)new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"A"))));
            checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"D"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"E"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new RowMutations(ROWKEY2).add((Mutation)new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"g"))).add((Mutation)new Delete(ROWKEY2).addColumns(FAMILY, Bytes.toBytes((String)"D"))));
            results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            result = table.get(new Get(ROWKEY));
            Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"A")));
            Assert.assertEquals((Object)"c", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
            result = table.get(new Get(ROWKEY2));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
        }
    }

    @Test
    public void testCheckAndMutateBatchWithFilterAndTimeRange() throws Throwable {
        try (Table table = this.createTable();){
            table.put(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")).addColumn(FAMILY, Bytes.toBytes((String)"B"), 100L, Bytes.toBytes((String)"b")).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")), new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"D"), 100L, Bytes.toBytes((String)"d")).addColumn(FAMILY, Bytes.toBytes((String)"E"), 100L, Bytes.toBytes((String)"e")).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f"))));
            CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).timeRange(TimeRange.between((long)0L, (long)101L)).build(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"g")));
            CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"D"), CompareOperator.EQUAL, Bytes.toBytes((String)"d")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"E"), CompareOperator.EQUAL, Bytes.toBytes((String)"e"))})).timeRange(TimeRange.between((long)0L, (long)100L)).build(new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"h")));
            List results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(0)).getResult());
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C")));
            Assert.assertEquals((Object)"g", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
            result = table.get(new Get(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"F")));
            Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
        }
    }

    @Test
    public void testCheckAndIncrementBatch() throws Throwable {
        try (Table table = this.createTable();){
            table.put(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((long)0L)), new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((long)0L))));
            CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Increment(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), 1L));
            CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifEquals(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"d")).build(new Increment(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"D"), 1L));
            List results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])((CheckAndMutateResult)results.get(0)).getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            result = table.get(new Get(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((long)0L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        }
    }

    @Test
    public void testCheckAndAppendBatch() throws Throwable {
        try (Table table = this.createTable();){
            table.put(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")), new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))));
            CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Append(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")));
            CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifEquals(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"d")).build(new Append(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
            List results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertEquals((Object)"bb", (Object)Bytes.toString((byte[])((CheckAndMutateResult)results.get(0)).getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            Result result = table.get(new Get(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((Object)"bb", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            result = table.get(new Get(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"D")));
            Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        }
    }

    @Test
    public void testCheckAndRowMutationsBatch() throws Throwable {
        try (Table table = this.createTable();){
            table.put(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((long)1L)).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")), new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f")).addColumn(FAMILY, Bytes.toBytes((String)"G"), Bytes.toBytes((long)1L)).addColumn(FAMILY, Bytes.toBytes((String)"H"), Bytes.toBytes((String)"h"))));
            CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])ROWKEY).ifEquals(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")).build(new RowMutations(ROWKEY).add(Arrays.asList(new Put(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")), new Delete(ROWKEY).addColumns(FAMILY, Bytes.toBytes((String)"B")), new Increment(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"C"), 1L), new Append(ROWKEY).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")))));
            CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])ROWKEY2).ifEquals(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"a")).build(new RowMutations(ROWKEY2).add(Arrays.asList(new Put(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")), new Delete(ROWKEY2).addColumns(FAMILY, Bytes.toBytes((String)"F")), new Increment(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"G"), 1L), new Append(ROWKEY2).addColumn(FAMILY, Bytes.toBytes((String)"H"), Bytes.toBytes((String)"h")))));
            List results = table.checkAndMutate(Arrays.asList(checkAndMutate1, checkAndMutate2));
            Assert.assertTrue((boolean)((CheckAndMutateResult)results.get(0)).isSuccess());
            Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])((CheckAndMutateResult)results.get(0)).getResult().getValue(FAMILY, Bytes.toBytes((String)"C"))));
            Assert.assertEquals((Object)"dd", (Object)Bytes.toString((byte[])((CheckAndMutateResult)results.get(0)).getResult().getValue(FAMILY, Bytes.toBytes((String)"D"))));
            Assert.assertFalse((boolean)((CheckAndMutateResult)results.get(1)).isSuccess());
            Assert.assertNull((Object)((CheckAndMutateResult)results.get(1)).getResult());
            Result result = table.get(new Get(ROWKEY));
            Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
            Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"B")));
            Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
            Assert.assertEquals((Object)"dd", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            result = table.get(new Get(ROWKEY2));
            Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"E")));
            Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"G"))));
            Assert.assertEquals((Object)"h", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"H"))));
        }
    }

    @Test
    public void testCheckAndMutateForNull() throws Exception {
        byte[] qualifier = Bytes.toBytes((String)"Q");
        try (Table table = this.createTable();){
            byte[] row1 = Bytes.toBytes((String)"testRow1");
            Put put = new Put(row1);
            put.addColumn(FAMILY, qualifier, Bytes.toBytes((String)"v0"));
            table.put(put);
            Assert.assertEquals((Object)"v0", (Object)Bytes.toString((byte[])table.get(new Get(row1).addColumn(FAMILY, qualifier)).getValue(FAMILY, qualifier)));
            CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])row1).ifMatches(FAMILY, qualifier, CompareOperator.NOT_EQUAL, new byte[0]).build(new Put(row1).addColumn(FAMILY, qualifier, Bytes.toBytes((String)"v1")));
            table.checkAndMutate(checkAndMutate1);
            Assert.assertEquals((Object)"v1", (Object)Bytes.toString((byte[])table.get(new Get(row1).addColumn(FAMILY, qualifier)).getValue(FAMILY, qualifier)));
            byte[] row2 = Bytes.toBytes((String)"testRow2");
            put = new Put(row2);
            put.addColumn(FAMILY, qualifier, new byte[0]);
            table.put(put);
            Assert.assertEquals((long)0L, (long)table.get(new Get(row2).addColumn(FAMILY, qualifier)).getValue(FAMILY, qualifier).length);
            CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row2).ifMatches(FAMILY, qualifier, CompareOperator.EQUAL, new byte[0]).build(new Put(row2).addColumn(FAMILY, qualifier, Bytes.toBytes((String)"v2")));
            table.checkAndMutate(checkAndMutate2);
            Assert.assertEquals((Object)"v2", (Object)Bytes.toString((byte[])table.get(new Get(row2).addColumn(FAMILY, qualifier)).getValue(FAMILY, qualifier)));
            byte[] row3 = Bytes.toBytes((String)"testRow3");
            put = new Put(row3).addColumn(FAMILY, qualifier, Bytes.toBytes((String)"v0"));
            Assert.assertNull((Object)table.get(new Get(row3).addColumn(FAMILY, qualifier)).getValue(FAMILY, qualifier));
            CheckAndMutate checkAndMutate3 = CheckAndMutate.newBuilder((byte[])row3).ifMatches(FAMILY, qualifier, CompareOperator.NOT_EQUAL, new byte[0]).build(put);
            table.checkAndMutate(checkAndMutate3);
            Assert.assertNull((Object)table.get(new Get(row3).addColumn(FAMILY, qualifier)).getValue(FAMILY, qualifier));
            CheckAndMutate checkAndMutate4 = CheckAndMutate.newBuilder((byte[])row3).ifMatches(FAMILY, qualifier, CompareOperator.EQUAL, new byte[0]).build(put);
            table.checkAndMutate(checkAndMutate4);
            Assert.assertEquals((Object)"v0", (Object)Bytes.toString((byte[])table.get(new Get(row3).addColumn(FAMILY, qualifier)).getValue(FAMILY, qualifier)));
        }
    }
}

