/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionNormalizerWorkQueue<E> {
    private LinkedHashSet<E> delegate = new LinkedHashSet();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Condition notEmpty = this.lock.writeLock().newCondition();

    RegionNormalizerWorkQueue() {
    }

    public void put(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.writeLock().lock();
        try {
            this.delegate.add(e);
            if (!this.delegate.isEmpty()) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void putFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.putAllFirst(Collections.singleton(e));
    }

    public void putAll(Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.lock.writeLock().lock();
        try {
            this.delegate.addAll(c);
            if (!this.delegate.isEmpty()) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void putAllFirst(Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.lock.writeLock().lock();
        try {
            LinkedHashSet<E> copy = new LinkedHashSet<E>(c.size() + this.delegate.size());
            copy.addAll(c);
            copy.addAll(this.delegate);
            this.delegate = copy;
            if (!this.delegate.isEmpty()) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public E take() throws InterruptedException {
        Object x;
        this.lock.writeLock().lockInterruptibly();
        try {
            while (this.delegate.isEmpty()) {
                this.notEmpty.await();
            }
            Iterator iter = this.delegate.iterator();
            x = iter.next();
            iter.remove();
            if (!this.delegate.isEmpty()) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return x;
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

