/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.RestUtil;
import org.apache.hadoop.hbase.rest.protobuf.generated.NamespacePropertiesMessage;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@XmlRootElement(name="NamespaceProperties")
@XmlAccessorType(value=XmlAccessType.FIELD)
@InterfaceAudience.Private
public class NamespacesInstanceModel
implements Serializable,
ProtobufMessageHandler {
    private static final long serialVersionUID = 1L;
    private Map<String, String> properties = null;
    @XmlTransient
    private String namespaceName;

    public NamespacesInstanceModel() {
    }

    public NamespacesInstanceModel(String namespaceName) throws IOException {
        this(null, namespaceName);
    }

    public NamespacesInstanceModel(Admin admin, String namespaceName) throws IOException {
        this.namespaceName = namespaceName;
        if (admin == null) {
            return;
        }
        NamespaceDescriptor nd = admin.getNamespaceDescriptor(namespaceName);
        if (nd.getConfiguration().isEmpty()) {
            return;
        }
        this.properties = new HashMap<String, String>();
        this.properties.putAll(nd.getConfiguration());
    }

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{NAME => '");
        sb.append(this.namespaceName);
        sb.append("'");
        if (this.properties != null) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                sb.append(", ");
                sb.append(entry.getKey());
                sb.append(" => '");
                sb.append(entry.getValue());
                sb.append("'");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Message messageFromObject() {
        NamespacePropertiesMessage.NamespaceProperties.Builder builder = NamespacePropertiesMessage.NamespaceProperties.newBuilder();
        if (this.properties != null) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                NamespacePropertiesMessage.NamespaceProperties.Property.Builder property = NamespacePropertiesMessage.NamespaceProperties.Property.newBuilder();
                property.setKey(key);
                property.setValue(entry.getValue());
                builder.addProps(property);
            }
        }
        return builder.build();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(CodedInputStream cis) throws IOException {
        NamespacePropertiesMessage.NamespaceProperties.Builder builder = NamespacePropertiesMessage.NamespaceProperties.newBuilder();
        RestUtil.mergeFrom((Message.Builder)builder, cis);
        List<NamespacePropertiesMessage.NamespaceProperties.Property> properties = builder.getPropsList();
        for (NamespacePropertiesMessage.NamespaceProperties.Property property : properties) {
            this.addProperty(property.getKey(), property.getValue());
        }
        return this;
    }
}

