/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreBase;
import org.apache.hadoop.hbase.procedure2.store.ProcedureTree;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.AtomicUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestStackIdHoles {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStackIdHoles.class);
    private final HBaseCommonTestingUtility HBTU = new HBaseCommonTestingUtility();
    private DummyProcedureStore procStore;
    private ProcedureExecutor<Void> procExec;

    @Before
    public void setUp() throws IOException {
        this.procStore = new DummyProcedureStore();
        this.procStore.start(4);
        this.procExec = new ProcedureExecutor(this.HBTU.getConfiguration(), null, (ProcedureStore)this.procStore);
        this.procExec.init(4, true);
        this.procExec.startWorkers();
    }

    @After
    public void tearDown() {
        this.procExec.stop();
    }

    @Test
    public void testLoad() throws IOException {
        this.procExec.submitProcedure((Procedure)new DummyProcedure());
        this.HBTU.waitFor(30000L, () -> !this.procExec.isRunning());
        this.procExec = new ProcedureExecutor(this.HBTU.getConfiguration(), null, (ProcedureStore)this.procStore);
        this.procExec.init(4, true);
    }

    public static class DummyProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        @Override
        protected Procedure<Void>[] execute(Void env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            return new Procedure[]{new ProcedureTestingUtility.NoopProcedure(), new ProcedureTestingUtility.NoopProcedure()};
        }
    }

    private final class DummyProcedureStore
    extends ProcedureStoreBase {
        private int numThreads;
        private final LinkedHashMap<Long, ProcedureProtos.Procedure> procMap = new LinkedHashMap();
        private final AtomicLong maxProcId = new AtomicLong(0L);
        private final AtomicBoolean updated = new AtomicBoolean(false);

        private DummyProcedureStore() {
        }

        public void start(int numThreads) throws IOException {
            this.numThreads = numThreads;
            this.setRunning(true);
        }

        public void stop(boolean abort) {
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public int setRunningProcedureCount(int count) {
            return count;
        }

        public void recoverLease() throws IOException {
        }

        public void load(ProcedureStore.ProcedureLoader loader) throws IOException {
            loader.setMaxProcId(this.maxProcId.get());
            ProcedureTree tree = ProcedureTree.build(this.procMap.values());
            loader.load(tree.getValidProcs());
            loader.handleCorrupted(tree.getCorruptedProcs());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insert(Procedure<?> proc, Procedure<?>[] subprocs) {
            long max = proc.getProcId();
            LinkedHashMap<Long, ProcedureProtos.Procedure> linkedHashMap = this.procMap;
            synchronized (linkedHashMap) {
                try {
                    this.procMap.put(proc.getProcId(), ProcedureUtil.convertToProtoProcedure(proc));
                    if (subprocs != null) {
                        for (Procedure<?> p : subprocs) {
                            this.procMap.put(p.getProcId(), ProcedureUtil.convertToProtoProcedure(p));
                            max = Math.max(max, p.getProcId());
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            AtomicUtils.updateMax((AtomicLong)this.maxProcId, (long)max);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insert(Procedure<?>[] procs) {
            long max = -1L;
            LinkedHashMap<Long, ProcedureProtos.Procedure> linkedHashMap = this.procMap;
            synchronized (linkedHashMap) {
                try {
                    for (Procedure<?> p : procs) {
                        this.procMap.put(p.getProcId(), ProcedureUtil.convertToProtoProcedure(p));
                        max = Math.max(max, p.getProcId());
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            AtomicUtils.updateMax((AtomicLong)this.maxProcId, (long)max);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Procedure<?> proc) {
            if (proc.hasParent() && proc.getStackIndexes() != null) {
                int lastStackId = proc.getStackIndexes()[proc.getStackIndexes().length - 1];
                try {
                    Thread.sleep(100L * (long)(10 - lastStackId));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (!this.updated.compareAndSet(false, true)) {
                    TestStackIdHoles.this.procExec.stop();
                    throw new RuntimeException("inject error");
                }
            }
            LinkedHashMap<Long, ProcedureProtos.Procedure> linkedHashMap = this.procMap;
            synchronized (linkedHashMap) {
                try {
                    this.procMap.put(proc.getProcId(), ProcedureUtil.convertToProtoProcedure(proc));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete(long procId) {
            LinkedHashMap<Long, ProcedureProtos.Procedure> linkedHashMap = this.procMap;
            synchronized (linkedHashMap) {
                this.procMap.remove(procId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete(Procedure<?> parentProc, long[] subProcIds) {
            LinkedHashMap<Long, ProcedureProtos.Procedure> linkedHashMap = this.procMap;
            synchronized (linkedHashMap) {
                try {
                    this.procMap.put(parentProc.getProcId(), ProcedureUtil.convertToProtoProcedure(parentProc));
                    for (long procId : subProcIds) {
                        this.procMap.remove(procId);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete(long[] procIds, int offset, int count) {
            LinkedHashMap<Long, ProcedureProtos.Procedure> linkedHashMap = this.procMap;
            synchronized (linkedHashMap) {
                for (int i = 0; i < count; ++i) {
                    long procId = procIds[offset + i];
                    this.procMap.remove(procId);
                }
            }
        }
    }
}

