<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

![hbase-logo](https://raw.githubusercontent.com/apache/hbase/master/src/site/resources/images/hbase_logo_with_orca_large.png)

[Apache HBase](https://hbase.apache.org) is an open-source, distributed, versioned, column-oriented store modeled after Google' [Bigtable](https://research.google.com/archive/bigtable.html): A Distributed Storage System for Structured Data by Chang et al. Just as Bigtable leverages the distributed data storage provided by the Google File System, HBase provides Bigtable-like capabilities on top of [Apache Hadoop](https://hadoop.apache.org/).

# Getting Start
To get started using HBase, the full documentation for this release can be found under the doc/ directory that accompanies this README. Using a browser, open the docs/index.html to view the project home page (or browse https://hbase.apache.org). The hbase '[book](https://hbase.apache.org/book.html)' has a 'quick start' section and is where you should being your exploration of the hbase project.

The latest HBase can be downloaded from the [download page](https://hbase.apache.org/downloads.html).

We use mailing lists to send notice and discuss. The mailing lists and archives are listed [here](http://hbase.apache.org/mail-lists.html)

# How to Contribute
The source code can be found at https://hbase.apache.org/source-repository.html

The HBase issue tracker is at https://hbase.apache.org/issue-tracking.html

Notice that, the public registration for https://issues.apache.org/ has been disabled due to spam. If you want to contribute to HBase, please send an email to [private@hbase.apache.org](mailto:private@hbase.apache.org) in the follow format so the HBase PMC members can acquire a jira account for you:

```
Subject: Request for Jira account

Contents of the mail(should be in English):
Preferred Jira Id: [a-z0-9]+
Full Name:
E-Mail Address:

Reason: Jira Id you wish to contribute to, or details around the bug/feature you wish to report or work on.
```

> **_NOTE:_** we need to process the requests manually so it may take sometime, for example, up to a week, for us to respond to your request.

# About
Apache HBase is made available under the [Apache License, version 2.0](https://hbase.apache.org/license.html)

The HBase distribution includes cryptographic software. See the export control notice [here](https://hbase.apache.org/export_control.html).
