/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.beans;

import grails.databinding.DataBinder;
import grails.util.Environment;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import jakarta.servlet.ServletContext;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.grails.web.binding.CompositeEditor;
import org.grails.web.binding.StructuredDateEditor;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PropertyEditorRegistryUtils
implements GroovyObject {
    private static final String PROPERTY_EDITOR_REGISTRARS = "org.codehaus.groovy.grails.PROPERTY_EDITOR_REGISTRARS";
    private static final String JSON_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public PropertyEditorRegistryUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void registerCustomEditors(GrailsWebRequest grailsWebRequest, PropertyEditorRegistry registry, Locale locale) {
        NumberFormat floatFormat = NumberFormat.getInstance(locale);
        NumberFormat integerFormat = NumberFormat.getIntegerInstance(locale);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DataBinder.DEFAULT_DATE_FORMAT, locale);
        registry.registerCustomEditor(Date.class, new CustomDateEditor(dateFormat, true));
        registry.registerCustomEditor(BigDecimal.class, new CustomNumberEditor(BigDecimal.class, floatFormat, true));
        registry.registerCustomEditor(BigInteger.class, new CustomNumberEditor(BigInteger.class, floatFormat, true));
        registry.registerCustomEditor(Double.class, new CustomNumberEditor(Double.class, floatFormat, true));
        registry.registerCustomEditor(Double.TYPE, new CustomNumberEditor(Double.class, floatFormat, true));
        registry.registerCustomEditor(Float.class, new CustomNumberEditor(Float.class, floatFormat, true));
        registry.registerCustomEditor(Float.TYPE, new CustomNumberEditor(Float.class, floatFormat, true));
        registry.registerCustomEditor(Long.class, new CustomNumberEditor(Long.class, integerFormat, true));
        registry.registerCustomEditor(Long.TYPE, new CustomNumberEditor(Long.class, integerFormat, true));
        registry.registerCustomEditor(Integer.class, new CustomNumberEditor(Integer.class, integerFormat, true));
        registry.registerCustomEditor(Integer.TYPE, new CustomNumberEditor(Integer.class, integerFormat, true));
        registry.registerCustomEditor(Short.class, new CustomNumberEditor(Short.class, integerFormat, true));
        registry.registerCustomEditor(Short.TYPE, new CustomNumberEditor(Short.class, integerFormat, true));
        registry.registerCustomEditor(Date.class, new CompositeEditor(new StructuredDateEditor(dateFormat, true), new CustomDateEditor(new SimpleDateFormat(JSON_DATE_FORMAT), true)));
        registry.registerCustomEditor(Calendar.class, new StructuredDateEditor(dateFormat, true));
        CallSite servletContext = IndyInterface.bootstrap("cast", "()", 0, grailsWebRequest != null ? grailsWebRequest.getServletContext() : null);
        PropertyEditorRegistryUtils.registerCustomEditorsFromContext((ServletContext)servletContext, registry);
    }

    private static void registerCustomEditorsFromContext(ServletContext servletContext, PropertyEditorRegistry registry) {
        Collection collection;
        if (servletContext == null) {
            return;
        }
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(servletContext);
        if (context == null) {
            return;
        }
        Object editors = IndyInterface.bootstrap("cast", "()", 0, servletContext.getAttribute(PROPERTY_EDITOR_REGISTRARS));
        if (editors == null) {
            editors = context.getBeansOfType(PropertyEditorRegistrar.class);
            if (!Environment.isDevelopmentMode()) {
                servletContext.setAttribute(PROPERTY_EDITOR_REGISTRARS, editors);
            }
        }
        Iterator iterator = (collection = editors.values()) != null ? collection.iterator() : null;
        CallSite editorRegistrar = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                editorRegistrar = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                editorRegistrar.registerCustomEditors(registry);
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PropertyEditorRegistryUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

