/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.geode.test.compiler;

import java.util.ArrayList;
import java.util.List;

import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.JavaFileObject.Kind;

/**
 * In-memory file manager used by an {@link InMemoryJavaCompiler}.
 */
public class InMemoryFileManager extends ForwardingJavaFileManager<JavaFileManager> {
  List<InMemoryClassFile> compiledClassFiles = new ArrayList<>();

  public InMemoryFileManager(JavaFileManager fileManager) {
    super(fileManager);
  }

  public List<InMemoryClassFile> compiledClasses() {
    return compiledClassFiles;
  }

  @Override
  public JavaFileObject getJavaFileForOutput(Location location, String className, Kind kind,
      FileObject sibling) {
    InMemoryClassFile file = new InMemoryClassFile(className);
    compiledClassFiles.add(file);
    return file;
  }
}
