/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.materializedtable;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;
import org.apache.flink.table.operations.materializedtable.MaterializedTableOperation;

@Internal
public class CreateMaterializedTableOperation
implements CreateOperation,
MaterializedTableOperation {
    private final ObjectIdentifier tableIdentifier;
    private final CatalogMaterializedTable materializedTable;

    public CreateMaterializedTableOperation(ObjectIdentifier tableIdentifier, ResolvedCatalogMaterializedTable materializedTable) {
        this.tableIdentifier = tableIdentifier;
        this.materializedTable = materializedTable;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ctx.getCatalogManager().createTable(this.materializedTable, this.tableIdentifier, false);
        return TableResultImpl.TABLE_RESULT_OK;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public CatalogMaterializedTable getCatalogMaterializedTable() {
        return this.materializedTable;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("materializedTable", this.materializedTable);
        params.put("identifier", this.tableIdentifier);
        return OperationUtils.formatWithChildren("CREATE MATERIALIZED TABLE", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

