/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterTableOperation;

@Internal
public class DropPartitionsOperation
extends AlterTableOperation {
    private final boolean ignoreIfPartitionNotExists;
    private final List<CatalogPartitionSpec> partitionSpecs;

    public DropPartitionsOperation(ObjectIdentifier tableIdentifier, boolean ignoreIfPartitionNotExists, List<CatalogPartitionSpec> partitionSpecs) {
        super(tableIdentifier, false);
        this.ignoreIfPartitionNotExists = ignoreIfPartitionNotExists;
        this.partitionSpecs = partitionSpecs;
    }

    public boolean ignoreIfPartitionNotExists() {
        return this.ignoreIfPartitionNotExists;
    }

    public List<CatalogPartitionSpec> getPartitionSpecs() {
        return this.partitionSpecs;
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder(String.format("ALTER TABLE %s DROP", this.tableIdentifier.asSummaryString()));
        if (this.ignoreIfPartitionNotExists) {
            builder.append(" IF EXISTS");
        }
        for (CatalogPartitionSpec spec : this.partitionSpecs) {
            builder.append(String.format(" PARTITION (%s)", OperationUtils.formatPartitionSpec(spec)));
        }
        return builder.toString();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ObjectPath tablePath = this.getTableIdentifier().toObjectPath();
        Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.getTableIdentifier().getCatalogName());
        try {
            for (CatalogPartitionSpec spec : this.getPartitionSpecs()) {
                catalog.dropPartition(tablePath, spec, this.ignoreIfPartitionNotExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

