/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.typeutils;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import scala.Product;

@Internal
public final class ScalaCaseClassSerializerSnapshot<T extends Product>
extends CompositeTypeSerializerSnapshot<T, ScalaCaseClassSerializer<T>> {
    private static final int VERSION = 2;
    private Class<T> type;

    public ScalaCaseClassSerializerSnapshot() {
    }

    public ScalaCaseClassSerializerSnapshot(ScalaCaseClassSerializer<T> serializerInstance) {
        super(serializerInstance);
        this.type = (Class)Preconditions.checkNotNull((Object)serializerInstance.getTupleClass(), (String)"tuple class can not be NULL");
    }

    protected int getCurrentOuterSnapshotVersion() {
        return 2;
    }

    protected TypeSerializer<?>[] getNestedSerializers(ScalaCaseClassSerializer<T> outerSerializer) {
        return outerSerializer.getFieldSerializers();
    }

    protected ScalaCaseClassSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"type can not be NULL");
        return new ScalaCaseClassSerializer<T>(this.type, nestedSerializers);
    }

    protected void writeOuterSnapshot(DataOutputView out) throws IOException {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"type can not be NULL");
        out.writeUTF(this.type.getName());
    }

    protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.type = InstantiationUtil.resolveClassByName((DataInputView)in, (ClassLoader)userCodeClassLoader);
    }

    protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(TypeSerializerSnapshot<T> oldSerializerSnapshot) {
        if (!(oldSerializerSnapshot instanceof ScalaCaseClassSerializerSnapshot)) {
            return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
        }
        ScalaCaseClassSerializerSnapshot oldSnapshot = (ScalaCaseClassSerializerSnapshot)oldSerializerSnapshot;
        return Objects.equals(this.type, oldSnapshot.type) ? CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS : CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
    }
}

