/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;

@Internal
public class EnrichedRowData
implements RowData {
    private final RowData fixedRow;
    private final int[] indexMapping;
    private RowData mutableRow;

    public EnrichedRowData(RowData fixedRow, int[] indexMapping) {
        this.fixedRow = fixedRow;
        this.indexMapping = indexMapping;
    }

    public EnrichedRowData replaceMutableRow(RowData mutableRow) {
        this.mutableRow = mutableRow;
        return this;
    }

    public int getArity() {
        return this.indexMapping.length;
    }

    public RowKind getRowKind() {
        return this.mutableRow.getRowKind();
    }

    public void setRowKind(RowKind kind) {
        this.mutableRow.setRowKind(kind);
    }

    public boolean isNullAt(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.isNullAt(index);
        }
        return this.fixedRow.isNullAt(-(index + 1));
    }

    public boolean getBoolean(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getBoolean(index);
        }
        return this.fixedRow.getBoolean(-(index + 1));
    }

    public byte getByte(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getByte(index);
        }
        return this.fixedRow.getByte(-(index + 1));
    }

    public short getShort(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getShort(index);
        }
        return this.fixedRow.getShort(-(index + 1));
    }

    public int getInt(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getInt(index);
        }
        return this.fixedRow.getInt(-(index + 1));
    }

    public long getLong(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getLong(index);
        }
        return this.fixedRow.getLong(-(index + 1));
    }

    public float getFloat(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getFloat(index);
        }
        return this.fixedRow.getFloat(-(index + 1));
    }

    public double getDouble(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getDouble(index);
        }
        return this.fixedRow.getDouble(-(index + 1));
    }

    public StringData getString(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getString(index);
        }
        return this.fixedRow.getString(-(index + 1));
    }

    public DecimalData getDecimal(int pos, int precision, int scale) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getDecimal(index, precision, scale);
        }
        return this.fixedRow.getDecimal(-(index + 1), precision, scale);
    }

    public TimestampData getTimestamp(int pos, int precision) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getTimestamp(index, precision);
        }
        return this.fixedRow.getTimestamp(-(index + 1), precision);
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getRawValue(index);
        }
        return this.fixedRow.getRawValue(-(index + 1));
    }

    public byte[] getBinary(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getBinary(index);
        }
        return this.fixedRow.getBinary(-(index + 1));
    }

    public ArrayData getArray(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getArray(index);
        }
        return this.fixedRow.getArray(-(index + 1));
    }

    public MapData getMap(int pos) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getMap(index);
        }
        return this.fixedRow.getMap(-(index + 1));
    }

    public RowData getRow(int pos, int numFields) {
        int index = this.indexMapping[pos];
        if (index >= 0) {
            return this.mutableRow.getRow(index, numFields);
        }
        return this.fixedRow.getRow(-(index + 1), numFields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrichedRowData that = (EnrichedRowData)o;
        return Objects.equals(this.fixedRow, that.fixedRow) && Objects.equals(this.mutableRow, that.mutableRow);
    }

    public int hashCode() {
        return Objects.hash(this.fixedRow, this.mutableRow);
    }

    public String toString() {
        return this.mutableRow.getRowKind().shortString() + "{fixedRow=" + this.fixedRow + ", mutableRow=" + this.mutableRow + '}';
    }

    public static EnrichedRowData from(RowData fixedRow, List<String> producedRowFields, List<String> mutableRowFields, List<String> fixedRowFields) {
        return new EnrichedRowData(fixedRow, EnrichedRowData.computeIndexMapping(producedRowFields, mutableRowFields, fixedRowFields));
    }

    public static int[] computeIndexMapping(List<String> producedRowFields, List<String> mutableRowFields, List<String> fixedRowFields) {
        int[] indexMapping = new int[producedRowFields.size()];
        for (int i = 0; i < producedRowFields.size(); ++i) {
            String fieldName = producedRowFields.get(i);
            int newIndex = mutableRowFields.indexOf(fieldName);
            if (newIndex < 0) {
                newIndex = -(fixedRowFields.indexOf(fieldName) + 1);
            }
            indexMapping[i] = newIndex;
        }
        return indexMapping;
    }
}

